#include "BNF.h"

#define out(a) //LOG(a) //Cout() << a;

int REG_CRC_START = 10;
int REG_CRC_END   = 11;
BNFarticle *bnfScheme = NULL;

word __modbus_crc(const char *buf, int l);
byte __wake_crc  (const Vector<byte> &bytes);
byte __m0803_crc (const Vector<byte> &bytes);

BNFarticle *BNFAddArticle(const String &nspace, const String &s, const String &desc, const Uuid &uid)
{
	//парсер по БНФ-описанию
	CreateDefaultBNFFunctions();
	
	BNFarticle *out = new BNFarticle;

	int nspaceI = bnfNamespaces.FindAdd(nspace);
	bnfNamespaces[nspaceI].Add(uid, out);
	out->name = s;
	out->uid  = uid;

	if (!desc.IsEmpty() && bnfScheme)
	{
		startArticle = out;
		ParseState state;
		state.state.re[0] << startElement;
		state.state.re[1] << startElement;
		state.inData = desc;
		
		bnfScheme->Parse(&state);
	}
	return out;
}

BNFarticle *BNFAddArticle(const String &nspace, const String &s, const String &desc)
{
	//парсер по БНФ-описанию
	CreateDefaultBNFFunctions();
	
	BNFarticle *out = new BNFarticle;

	int nspaceI = bnfNamespaces.FindAdd(nspace);
	bnfNamespaces[nspaceI].Add(out->uid, out);
	out->name = s;

	if (!desc.IsEmpty() && bnfScheme)
	{
		startArticle = out;
		ParseState state;
		state.state.re[0] << startElement;
		state.state.re[1] << startElement;
		state.inData = desc;
		
		bnfScheme->Parse(&state);
	}
	return out;
}

//----------------------------------------------------------------------------------------------
bool BNFarg_gen(GenState *state, Value v)
{
	if (state->state.inOffset >= state->inValues.GetCount())
		return false;
	
	return (v == state->inValues[state->state.inOffset++]);
}

bool BNFany_gen(GenState *state, Value v)
{
	return false;
}

bool BNFset_rep_gen(GenState *state, Value v)
{
	if (state->state.inOffset < 1 || state->state.inOffset-1 >= state->inValues.GetCount())
		return false;
	if (!state->inValues[state->state.inOffset-1].Is<int>())
		return false;
	int n = state->inValues[state->state.inOffset-1];
	state->state.ri[9] << n;
	return true;
}

bool BNFrep_gen(GenState *state, Value v)
{
	if (state->state.ri[9].IsEmpty())
		return false;
	
	return (state->state.ri[9].Top()--) > 0;
}

bool BNFhex_gen(GenState *state, Value v)
{
	if (state->state.inOffset >= state->inValues.GetCount())
		return false;
	Value _v = state->inValues[state->state.inOffset++];
	if (!v.Is<int>() || !_v.Is<int>())
		return false;
	
	state->state.outData << FormatIntHex(static_cast<int>(_v),static_cast<int>(v)).Right(static_cast<int>(v));
	return true;
}

bool BNFHEX_gen(GenState *state, Value v)
{
	if (state->state.inOffset >= state->inValues.GetCount())
		return false;
	Value _v = state->inValues[state->state.inOffset++];
	if (!v.Is<int>() || !_v.Is<int>())
		return false;
	
	state->state.outData << ToUpper(FormatIntHex(static_cast<int>(_v),static_cast<int>(v)).Right(static_cast<int>(v)));
	return true;
}

bool BNFdup_gen(GenState *state, Value v)
{
	if (!IsNumber(v))
		return false;
	if (state->state.inOffset >= state->inValues.GetCount())
	{
		out(Format("--dup: %d/%d", state->state.inOffset, state->inValues.GetCount()));
		return false;
	}

	byte b = (int) state->inValues[state->state.inOffset];
	if ((int)v)
		state->state.ri[(int)v] << b;
	else
		state->inValues << b;
	return true;
}

template<typename T1, typename T2> bool BNFtype_gen(GenState *state, Value v)
{
	if (state->state.inOffset >= state->inValues.GetCount())
		return false;
	Value _v = state->inValues[state->state.inOffset++];
	if (!_v.Is<T1>())
		return false;
	T2 i = static_cast<T2>(static_cast<T1>(_v));
	state->state.outData.Cat((const char *) &i, sizeof(T2));
	return true;
}

template<typename T1, typename T2> bool BNFtype_be_gen(GenState *state, Value v)
{
	if (state->state.inOffset >= state->inValues.GetCount())
		return false;
	Value _v = state->inValues[state->state.inOffset++];
	if (!_v.Is<T1>())
		return false;
	T2 t = (T2) static_cast<T1>(_v);
	for (int j=sizeof(T2)-1; j>=0; --j)
		state->state.outData.Cat((char) (((char *) &t)[j]));
	return true;
}

bool BNFstr_nonctrl_gen(GenState *state, Value v)
{
	if (state->state.inOffset >= state->inValues.GetCount())
		return false;
	Value _v = state->inValues[state->state.inOffset++];
	if (!IsString(_v))
		return false;
	String s = (String) _v;
	for (int i=0; i<s.GetLength(); ++i)
		if (s[i] < 0x20)
		{
			s.Trim(i);
			break;
		}
	
	state->state.outData << s;
	return true;
}

bool BNFcrc_start_gen(GenState *state, Value v)
{
	state->state.ri[11] << state->state.outData.GetLength();
	state->state.ri[12] << state->state.inOffset;
	return true;
}

bool BNFcrc_end_gen(GenState *state, Value v)
{
	if (state->state.outData.IsEmpty())
		return false;
	state->state.ri[11] << state->state.outData.GetLength()-1;
	state->state.ri[12] << state->state.inOffset;
	return true;
}

bool BNFcrc_modbus_gen(GenState *state, Value v)
{
	static const int CRC_LENGTH = 2;
	if (state->state.ri[11].GetCount() < 2)
		return false;
	int endOffs   = state->state.ri[11].Pop();
	int startOffs = state->state.ri[11].Pop();
	if (startOffs > endOffs || startOffs >= state->state.outData.GetLength() || endOffs >= state->state.outData.GetLength())
		return false;
	word crc = __modbus_crc( (const char *) (~(state->state.outData) + startOffs), endOffs-startOffs+1 );
	state->state.outData.Cat((const char *) &crc, sizeof(crc));
	
	return true;
}

bool BNFcrc_wake_gen(GenState *state, Value v)
{
	if (state->state.ri[12].GetCount() < 2)
		return false;
	int vI1 = state->state.ri[12][state->state.ri[12].GetCount()-2];
	int vI2 = state->state.ri[12][state->state.ri[12].GetCount()-1];
	if (vI1<0 || vI2<0 || vI1>=state->inValues.GetCount() || vI2>=state->inValues.GetCount())
		return false;
	Vector<byte> bytes;
	for (int i=vI1; i<=vI2; ++i)
	{
		if (!state->inValues[i].Is<int>())
			return false;
		
		bytes << ((byte) (int) (state->inValues[i]));
	}
	
	byte crc = __wake_crc(bytes);
	state->state.outData.Cat((const char *) &crc, sizeof(crc));
	return true;
}

bool BNFcrc_m0803_gen(GenState *state, Value v)
{
	if (!IsNumber(v))
		return false;
	if (state->state.ri[12].GetCount() < 2)
		return false;
	int vI1 = state->state.ri[12][state->state.ri[12].GetCount()-2];
	int vI2 = state->state.ri[12][state->state.ri[12].GetCount()-1];
	if (vI1<0 || vI2<0 || (vI2-vI1)>state->state.ri[(int)v].GetCount())
		return false;
	Vector<byte> bytes;
	for (int i=state->state.ri[(int)v].GetCount()-(vI2-vI1); i<state->state.ri[(int)v].GetCount(); ++i)
	{
		bytes << ((byte) (state->state.ri[(int)v][i]));
	}
	
	byte crc = __m0803_crc(bytes);
	state->state.outData.Cat((const char *) &crc, sizeof(crc));
	return true;
}

bool BNFstr_quoted_gen(GenState *state, Value v)
{
	if (state->state.inOffset >= state->inValues.GetCount())
		return false;
	Value _v = state->inValues[state->state.inOffset++];
	if (!_v.Is<String>())
		return false;
	String s = static_cast<String>(_v);
	state->state.outData << '"';
	for (int i=0; i<s.GetLength(); ++i)
	{
		byte b = (byte) s[i];
		if (b < 0x20)
			state->state.outData << Format("\\%02X", ((int) b) & 0xFF);
		else
			state->state.outData << ((char) b);
	}
	state->state.outData << '"';
	return true;
}

bool BNFstr_int_gen(GenState *state, Value v)
{
	if (state->state.inOffset >= state->inValues.GetCount())
		return false;

	String prefix = "%";
	if (v.Is<int>() && static_cast<int>(v)>0)
		prefix << Format("%02d", static_cast<int>(v));

	Value _v = state->inValues[state->state.inOffset++];
	if (_v.Is<int>())
	{
		state->state.outData << Format(prefix+"d", static_cast<int>(_v));
		return true;
	}
	else if (_v.Is<int64>())
	{
		state->state.outData << Format(prefix+"ld", static_cast<int64>(_v));
		return true;
	}

	return false;
}

bool BNFstr_double_gen(GenState *state, Value v)
{
	if (state->state.inOffset >= state->inValues.GetCount())
		return false;
	Value _v = state->inValues[state->state.inOffset++];
	if (!_v.Is<double>())
		return false;

	String prefix = "%";
	if (v.Is<int>() && static_cast<int>(v)>0)
		prefix << Format("%02d", static_cast<int>(v));

	state->state.outData << Format(prefix+"f", static_cast<double>(_v));
	return true;
}

//----------------------------------------------------------------------------------------------
bool BNFarg_parse(ParseState *state, Value v)
{
	state->state.values << v;
	return true;
}

bool BNFany_parse(ParseState *state, Value v)
{
	if (state->state.inOffset == state->inData.GetLength())
		return false;
	
	++state->state.inOffset;
	return true;
}

bool BNFset_rep_parse(ParseState *state, Value v)
{
	if (state->state.values.IsEmpty() || !state->state.values.Top().Is<int>())
		return false;
	state->state.ri[9] << state->state.values.Top();
	return true;
}

bool BNFrep_parse(ParseState *state, Value v)
{
	if (state->state.ri[9].IsEmpty())
		return false;
	
	return (state->state.ri[9].Top()--) > 0;
}

bool BNFHEX_parse(ParseState *state, Value v)
{
	if (!v.Is<int>())
		return false;
	int cnt = static_cast<int>(v);
	if (state->inData.GetLength() < state->state.inOffset+cnt)
		return false;
	
	const String s = state->inData.Mid(state->state.inOffset,cnt);
	int i = ScanInt(~s,NULL,16);
	state->state.values << i;
	state->state.inOffset += cnt;
	return true;
}

template <typename T1, typename T2> bool BNFtype_parse(ParseState *state, Value v)
{
	if (state->inData.GetLength() < (int) (state->state.inOffset+sizeof(T2)))
		return false;
	T2 *i = (T2 *) (((const char *) state->inData) + state->state.inOffset);
	state->state.values << ((T1) *i);
	state->state.inOffset += sizeof(T2);
	return true;
}

template <typename T1, typename T2> bool BNFtype_be_parse(ParseState *state, Value v) //i.e. <int,byte>
{
	if (state->inData.GetLength() < (int) (state->state.inOffset+sizeof(T2)))
		return false;
	T2 t;
	int j=0;
	byte *sb = (byte *) (~state->inData + state->state.inOffset);
	byte *b  = (byte *) &t;
	for (int i=sizeof(T2)-1; i>=0; --i, ++j)
		b[i] = sb[j];
	state->state.values << ((T1) t);
	state->state.inOffset += sizeof(T2);
	return true;
}

bool BNFstr_nonctrl_parse(ParseState *state, Value v)
{
	int i = state->state.inOffset;
	for (; i<state->inData.GetLength(); ++i)
		if (state->inData[i] < 0x20)
			break;
	
	state->state.values << state->inData.Mid(state->state.inOffset, i-state->state.inOffset);
	state->state.inOffset = i;
	return true;
}

bool BNFcrc_start_parse(ParseState *state, Value v)
{
	state->state.ri[11] << state->state.inOffset;
	state->state.ri[12] << state->state.values.GetCount()-1;
	return true;
}

bool BNFcrc_end_parse(ParseState *state, Value v)
{
	if (state->state.inOffset <= 0)
		return false;
	state->state.ri[11] << state->state.inOffset-1;
	state->state.ri[12] << state->state.values.GetCount()-1;
	return true;
}

bool BNFcrc_modbus_parse(ParseState *state, Value v)
{
	static const int CRC_LENGTH = 2;
	int gl = state->inData.GetLength();
	int io = state->state.inOffset;
	if (gl < io+CRC_LENGTH)
//	if (state->inData.GetLength() < state->state.inOffset+CRC_LENGTH)
		return false;
	
	gl = io = 5;
	
	if (state->state.ri[11].GetCount() < 2)
		return false;
	int endOffs   = state->state.ri[11].Pop();
	int startOffs = state->state.ri[11].Pop();
	word *testCRC = (word *) (~(state->inData) + state->state.inOffset++);
	
	gl = io = 10;
	return (  __modbus_crc( (~(state->inData)+startOffs), endOffs-startOffs+1 ) == *testCRC  );
}

bool BNFcrc_wake_parse(ParseState *state, Value v)
{
	byte *testCRC = (byte *) (~(state->inData) + state->state.inOffset++);
	return !!testCRC;
}

bool BNFcrc_m0803_parse(ParseState *state, Value v)
{
	byte *testCRC = (byte *) (~(state->inData) + state->state.inOffset++);
	return true;
}

bool BNFstr_quoted_parse(ParseState *state, Value v)
{
	if (state->state.inOffset < 0)
		return false;

	String out;
	bool first = true;
	for (; state->state.inOffset < state->inData.GetLength(); ++state->state.inOffset)	
	{
		if (first)
		{
			first = false;
			if (state->inData[state->state.inOffset] != '"')
				return false;

			continue;
		}
		
		if (state->inData[state->state.inOffset] == '\\' && state->inData.GetLength() >= state->state.inOffset+2 && state->inData[state->state.inOffset+1] == '"')
		{
			out << '"';
			state->state.inOffset += 1;
		}
		else
		if (state->inData[state->state.inOffset] == '\\' && state->inData.GetLength() >= state->state.inOffset+2 && state->inData[state->state.inOffset+1] == '\\')
		{
			out << '\\';
			state->state.inOffset += 1;
		}
		else
		if (state->inData[state->state.inOffset] == '\\' && state->inData.GetLength() >= state->state.inOffset+3)
		{
			char b = ScanInt(state->inData.Mid(state->state.inOffset+1, 2), NULL, 16);
			out << b;
			state->state.inOffset += 2;
		}
		else
		if (state->inData[state->state.inOffset] == '"')
		{
			state->state.values << out;
			++state->state.inOffset;
			return true;
		}
		else
			out << ((char) state->inData[state->state.inOffset]);
	}
	
	return false;
}

bool BNFstr_int_parse(ParseState *state, Value v)
{
	int oldOffset = state->state.inOffset;
	bool first = true;
	
	if (state->state.inOffset+2<state->inData.GetLength() && state->inData[state->state.inOffset] == '0' && state->inData[state->state.inOffset+1] == 'x')
	{// hex?
		state->state.inOffset += 2;
		for (; state->state.inOffset < state->inData.GetLength(); ++state->state.inOffset)
		{
			char c = state->inData[state->state.inOffset];
			if (IsDigit(c) || (c>='a' && c<='f') || (c>='A' && c<='F'))
				continue;
			
			break;
		}
		if (state->state.inOffset - oldOffset <= 2)
			return false;
		
		int n = ScanInt(state->inData.Mid(oldOffset+2, state->state.inOffset-oldOffset-2), NULL, 16);
		state->state.values << n;
		
		return true;
	}
	
	// decimal?
	for (; state->state.inOffset < state->inData.GetLength(); ++state->state.inOffset)
	{
		if (first)
		{
			if (  !IsDigit(state->inData[state->state.inOffset]) 
				&& state->inData[state->state.inOffset] != '-'
				&& state->inData[state->state.inOffset] != '+'
				)
			return false;
		
			first = false;
			continue;
		}
		
		if (IsDigit(state->inData[state->state.inOffset]))
			continue;
		else
			break;
	}
	if (state->state.inOffset == oldOffset)
		return false;
	
	int n = StdConvertInt().Scan(state->inData.Mid(oldOffset, state->state.inOffset-oldOffset));
	state->state.values << n;
	return true;
}

bool BNFstr_double_parse(ParseState *state, Value v)
{
	int oldOffset = state->state.inOffset;
	bool first = true;
	bool dotFound = false;
	for (; state->state.inOffset < state->inData.GetLength(); ++state->state.inOffset)	
	{
		if (first)
		{
			first = false;
			if (!IsDigit(state->inData[state->state.inOffset]) 
				&& state->inData[state->state.inOffset] != '-'
				&& state->inData[state->state.inOffset] != '+'
				&& state->inData[state->state.inOffset] != '.'
				&& state->inData[state->state.inOffset] != ','
				)
				return false;
			
			first = false;
			continue;
		}
		
		if (state->inData[state->state.inOffset] == '.'
		 || state->inData[state->state.inOffset] == ','
		    )
		    dotFound = true;
		
		if (IsDigit(state->inData[state->state.inOffset])
			|| state->inData[state->state.inOffset] == '.'
			|| state->inData[state->state.inOffset] == ','
			)
			continue;
		else
			break;
	}
	if (!dotFound || state->state.inOffset == oldOffset)
		return false;
	
	double d = StdConvertDouble().Scan(state->inData.Mid(oldOffset, state->state.inOffset-oldOffset));
	state->state.values << d;
	return true;
}

//----------------------------------------------------------------------------------------------
bool BNFbranch_parse(ParseState *state, Value v)
{
	BNFelement *newStartEl, *newEndEl;
	BNFelement *newEl = startArticle->AppendBranch(false, state->state.re[0].Top(), state->state.re[1].Top(), &newStartEl, &newEndEl);
	state->state.re[1].Pop();
	state->state.re[1] << newEndEl;

	state->state.re[0] << newEl;
	state->state.re[1] << newEl;
	out(Format("\n\tBRANCH { [%d %d] << [%d %d]\n", newStartEl->debugID, newEndEl->debugID, state->state.re[0].Top()->debugID, state->state.re[1].Top()->debugID));
	return true;
}

bool BNFbranch_end_parse(ParseState *state, Value v)
{
	state->state.re[0].Pop();
	state->state.re[1].Pop();
	out(Format("\n\t} //BRANCH [%d %d]\n", state->state.re[0].Top()->debugID, state->state.re[1].Top()->debugID));
	return true;
}

bool BNFgroup_parse(ParseState *state, Value v)
{
	state->state.re[0] << state->state.re[1].Top();
	out(Format("\n\tGROUP ( [%d %d]\n", state->state.re[0].Top()->debugID, state->state.re[1].Top()->debugID));
	return true;
}

bool BNFgroup_end_parse(ParseState *state, Value v)
{
	state->state.re[0].Pop();
	out(Format("\n\t) GROUP //[%d %d]\n", state->state.re[0].Top()->debugID, state->state.re[1].Top()->debugID));
	return true;
}

bool BNFoption_parse(ParseState *state, Value v)
{
	BNFelement *newLink = startArticle->AppendLink(state->state.re[1].Top());
	state->state.re[1].Pop();
	state->state.re[1] << newLink;

	BNFelement *newStartEl, *newEndEl;
	BNFelement *newEl = startArticle->AppendBranch(false, newLink, newLink, &newStartEl, &newEndEl);
	state->state.re[1].Pop();
	state->state.re[1] << newEndEl;

	state->state.re[0] << newLink;
	state->state.re[1] << newLink;
	out(Format("\n\tOPTION [ [%d %d] << [%d %d]\n", newStartEl->debugID, newEndEl->debugID, state->state.re[0].Top()->debugID, state->state.re[1].Top()->debugID));
	
	return true;
}

bool BNFoption_end_parse(ParseState *state, Value v)
{
	state->state.re[0].Pop();
	state->state.re[1].Pop();
	out(Format("\n\t] OPTION //[%d %d]\n", state->state.re[0].Top()->debugID, state->state.re[1].Top()->debugID));
	return true;
}

bool BNFrepeat_parse(ParseState *state, Value v)
{
	BNFelement *newLink = startArticle->AppendLink(state->state.re[1].Top());
	state->state.re[1].Pop();
	state->state.re[1] << newLink;

	BNFelement *newStartEl, *newEndEl;
	BNFelement *newEl = startArticle->AppendBranch(true, newLink, newLink, &newStartEl, &newEndEl);
	state->state.re[1].Pop();
	state->state.re[1] << newEndEl;

	state->state.re[0] << newEl;
	state->state.re[1] << newEl;
	out(Format("\n\tREPEAT { [%d %d] << [%d %d]\n", newStartEl->debugID, newEndEl->debugID, state->state.re[0].Top()->debugID, state->state.re[1].Top()->debugID));
	
	return true;
}

bool BNFrepeat_end_parse(ParseState *state, Value v)
{
	state->state.re[0].Pop();
	state->state.re[1].Pop();
	out(Format("\n\t} REPEAT //[%d %d]\n", state->state.re[0].Top()->debugID, state->state.re[1].Top()->debugID));
	return true;
}

//----------------------------------------------------------------------------------------------
bool BNFstr_parse(ParseState *state, Value v)
{
	String delim;
	if (v.GetType() == STRING_V)
		delim = static_cast<String>(v);
	
	int oldInOffset = state->state.inOffset;
	out("(");
	while (state->state.inOffset < state->inData.GetLength())
	{
		if (delim.Find(state->inData[state->state.inOffset]) >= 0)
			break;
		//out((char)state->inData[state->state.inOffset]);
		++(state->state.inOffset);
	}
	out(DumpifyString(state->inData.Mid(oldInOffset, state->state.inOffset-oldInOffset)));
	out(")");
	if (state->state.inOffset == oldInOffset)
		return false;
	
	String s = state->inData.Mid(oldInOffset, state->state.inOffset-oldInOffset);
	for (int i=0; i<s.GetLength(); ++i)
	{
		if (s[i] == '\\' && s.GetLength() >= i+3)
		{
			char c = ScanInt(~(s.Mid(i+1,2)),NULL,16);
			s.Remove(i+1,2);
			s.Set(i,c);
		}
	}
	state->state.rs[10] << s;
	return true;
}

bool BNFstr10_parse(ParseState *state, Value v)
{
	if (v.GetType() == STRING_V)
		state->state.rs[10] << static_cast<String>(v);
	
	return true;
}

bool BNFdup_parse(ParseState *state, Value v)
{
	return true;
}

bool BNFterm_end_parse(ParseState *state, Value v)
{
	if (state->state.re[1].IsEmpty() || state->state.rs[10].IsEmpty())
		return false;
	
	BNFelement *newEndEl = startArticle->AppendElement(state->state.re[1].Top(), new BNFterminal(state->state.rs[10].Pop()));
	state->state.re[1].Pop();
	state->state.re[1] << newEndEl;
	
	return true;
}

bool BNFnonterm_end_parse(ParseState *state, Value v)
{
	String name   = state->state.rs[10].Pop();
	String nspace = state->state.rs[10].Pop();
	BNFarticles &bnfArticles = bnfNamespaces.GetAdd(nspace);
	out(Format("[%s(%d)::%s]", nspace, bnfArticles.GetCount(), name));
	for (int i=0; i<bnfArticles.GetCount(); ++i)
	{
		if (bnfArticles[i].name == name)
		{
			BNFelement *newEndEl = startArticle->AppendElement(state->state.re[1].Top(), new BNFnonterminal(nspace, bnfArticles[i].uid));
			state->state.re[1].Pop();
			state->state.re[1] << newEndEl;
			
			return true;
		}
	}
	
	return false;
}

bool BNFcode_end_parse(ParseState *state, Value v)
{
	//if (state->state.rs[10].IsEmpty() || state->state.rv[10].IsEmpty())
	//	return false;
	
	const String codeN = state->state.rs[10].Pop();
	out("added func: " + codeN);
	BNFelement *newEndEl = startArticle->AppendElement(state->state.re[1].Top(), new BNFcode(codeN, state->state.rv[10].Pop()));
	state->state.re[1].Pop();
	state->state.re[1] << newEndEl;
	
	return true;
}

bool BNFrv_parse(ParseState *state, Value v)
{
	state->state.rv[10] << v;
	return true;
}

bool BNFstring_parse(ParseState *state, Value v)
{
	if (state->state.rs[10].IsEmpty())
		return false;
	
	state->state.rv[10] << state->state.rs[10].Pop();
	return true;
}

bool BNFdecimal_parse(ParseState *state, Value v)
{
	if (state->state.rs[10].IsEmpty())
		return false;
	String s = state->state.rs[10].Pop();
	if (s.Find(".") >= 0)
	{
		Value i = ConvertDouble().Scan(s);
		if (i.IsVoid())
			return false;
		state->state.rv[10] << i;
	}
	else if (s.GetLength() > 2 && s[0]=='0' && s[1]=='x')
	{
		s.Remove(0,2);
		int i = (int) ScanInt(~s,NULL,16);
		state->state.rv[10] << i;
	}
	else
	{
		Value i = (int) ConvertInt().Scan(s);
		if (i.IsVoid())
			return false;
		state->state.rv[10] << i;
	}

	return true;
}

bool BNFend_parse(ParseState *state, Value v)
{
	state->stop = true;
	return true;
}

bool BNFresume_parse(ParseState *state, Value v)
{
	state->stop = false;
	return true;
}

bool BNFnewScheme_parse(ParseState *state, Value v)
{
	if (state->state.rs[10].GetCount() < 2)
		return false;
	
	String s = state->state.rs[10].Pop();
	String sname = state->state.rs[10].Pop();
	BNFarticle *out = BNFAddArticle(sname, s);
	startArticle = out;
	state->state.re[0] << startElement;
	state->state.re[1] << startElement;
	return true;
}

//----------------------------------------------------------------------------------------------
void CreateDefaultBNFFunctions()
{
	static bool commonBNFparserCreated = false;
	if (commonBNFparserCreated)
		return;
	else
		commonBNFparserCreated = true;
	
	bnfNamespaces.Add(NAMESPACE_BNF);
	
	bnfGenProcs.Add("arg",      &BNFarg_gen);
	bnfGenProcs.Add("hex",      &BNFhex_gen);
	bnfGenProcs.Add("HEX",      &BNFHEX_gen);
	bnfGenProcs.Add("str_quoted",&BNFstr_quoted_gen);
	bnfGenProcs.Add("str_int",  &BNFstr_int_gen);
	bnfGenProcs.Add("str_float",&BNFstr_double_gen);
	bnfGenProcs.Add("any",      &BNFany_gen);

	bnfGenProcs.Add("byte",   &BNFtype_gen<int,byte>);
	bnfGenProcs.Add("word",   &BNFtype_gen<int,word>);
	bnfGenProcs.Add("dword",  &BNFtype_gen<int,dword>);
	bnfGenProcs.Add("double", &BNFtype_gen<double,double>);
	bnfGenProcs.Add("float",  &BNFtype_gen<double,double>);
	bnfGenProcs.Add("word_be",   &BNFtype_be_gen<int,word>);
	bnfGenProcs.Add("dword_be",  &BNFtype_be_gen<int,dword>);
	bnfGenProcs.Add("double_be", &BNFtype_be_gen<double,double>);
	bnfGenProcs.Add("float_be",  &BNFtype_be_gen<double,double>);

/*	bnfGenProcs.Add("word_me",   &BNFtype_me_gen<int,word>);
	bnfGenProcs.Add("dword_me",  &BNFtype_me_gen<int,dword>);
	bnfGenProcs.Add("double_me", &BNFtype_me_gen<double,double>);
	bnfGenProcs.Add("float_me",  &BNFtype_me_gen<double,double>);*/
	
	bnfGenProcs.Add("str_nonctrl",  &BNFstr_nonctrl_gen);
	bnfGenProcs.Add("set_rep",  &BNFset_rep_gen);
	bnfGenProcs.Add("rep",  &BNFrep_gen);
	bnfGenProcs.Add("dup",  &BNFdup_gen);

	bnfGenProcs.Add("crc_start",  &BNFcrc_start_gen);
	bnfGenProcs.Add("crc_end",    &BNFcrc_end_gen);
	bnfGenProcs.Add("crc_modbus", &BNFcrc_modbus_gen);
	bnfGenProcs.Add("crc_wake",   &BNFcrc_wake_gen);
	bnfGenProcs.Add("crc_m0803",  &BNFcrc_m0803_gen);

	//----------------------------------------------------------------
	bnfParseProcs.Add("arg",    &BNFarg_parse);
	bnfParseProcs.Add("hex",    &BNFHEX_parse);
	bnfParseProcs.Add("HEX",    &BNFHEX_parse);
	bnfParseProcs.Add("str_quoted",&BNFstr_quoted_parse);
	bnfParseProcs.Add("str_int",  &BNFstr_int_parse);
	bnfParseProcs.Add("str_float",&BNFstr_double_parse);
	bnfParseProcs.Add("any",     &BNFany_parse);

	bnfParseProcs.Add("byte",   &BNFtype_parse<int,byte>);
	bnfParseProcs.Add("word",   &BNFtype_parse<int,word>);
	bnfParseProcs.Add("dword",  &BNFtype_parse<int,dword>);
	bnfParseProcs.Add("float",  &BNFtype_parse<double,double>);
	bnfParseProcs.Add("double", &BNFtype_parse<double,double>);
	bnfParseProcs.Add("word_be",   &BNFtype_be_parse<int,word>);
	bnfParseProcs.Add("dword_be",  &BNFtype_be_parse<int,dword>);
	bnfParseProcs.Add("float_be",  &BNFtype_be_parse<double,double>);
	bnfParseProcs.Add("double_be", &BNFtype_be_parse<double,double>);
	bnfParseProcs.Add("str_nonctrl",  &BNFstr_nonctrl_parse);

	bnfParseProcs.Add("set_rep",  &BNFset_rep_parse);
	bnfParseProcs.Add("rep",  &BNFrep_parse);
	bnfParseProcs.Add("dup",  &BNFdup_parse);

	bnfParseProcs.Add("crc_start",  &BNFcrc_start_parse);
	bnfParseProcs.Add("crc_end",    &BNFcrc_end_parse);
	bnfParseProcs.Add("crc_modbus", &BNFcrc_modbus_parse);
	bnfParseProcs.Add("crc_wake",   &BNFcrc_wake_parse);
	bnfParseProcs.Add("crc_m0803",  &BNFcrc_m0803_parse);

	bnfParseProcs.Add("BNFbranch",     &BNFbranch_parse);
	bnfParseProcs.Add("BNFbranch_end", &BNFbranch_end_parse);
	bnfParseProcs.Add("BNFgroup",      &BNFgroup_parse);
	bnfParseProcs.Add("BNFgroup_end",  &BNFgroup_end_parse);
	bnfParseProcs.Add("BNFoption",     &BNFoption_parse);
	bnfParseProcs.Add("BNFoption_end", &BNFoption_end_parse);
	bnfParseProcs.Add("BNFrepeat",     &BNFrepeat_parse);
	bnfParseProcs.Add("BNFrepeat_end", &BNFrepeat_end_parse);
	bnfParseProcs.Add("BNFstr",        &BNFstr_parse);
	bnfParseProcs.Add("BNFstr10",      &BNFstr10_parse);
	bnfParseProcs.Add("BNFterm_end",   &BNFterm_end_parse);
	bnfParseProcs.Add("BNFnonterm_end",&BNFnonterm_end_parse);
	bnfParseProcs.Add("BNFcode_end",   &BNFcode_end_parse);
	bnfParseProcs.Add("BNFrv",         &BNFrv_parse);
	bnfParseProcs.Add("BNFstring",     &BNFstring_parse);
	bnfParseProcs.Add("BNFdecimal",    &BNFdecimal_parse);
	bnfParseProcs.Add("BNFend",        &BNFend_parse);
	bnfParseProcs.Add("BNFresume",     &BNFresume_parse);
	bnfParseProcs.Add("BNFnewScheme",  &BNFnewScheme_parse);

	// ------------------  РБНФ парсер  ----------------------
	BNFarticle *bnfArg = BNFAddArticle(NAMESPACE_BNF, "BNFarg");
	*bnfArg
		>=true >="\"" >BNFcode("BNFstr","\"") >="\"" >BNFcode("BNFstring") >=false
		<=false  >BNFcode("BNFstr"," *;|()[]{}\"<>:\n\r\t") >BNFcode("BNFdecimal") <=0
	;
	
	BNFarticle *bnfWhite = BNFAddArticle(NAMESPACE_BNF, "BNFwhite");
	*bnfWhite
		>=false >=0    >=true
		<=true  >=" "  <=0
		<=true  >="\n" <=0
		<=true  >="\t" <=0
		<=true  >="\r" <=0
	;

	BNFarticle *bnfStopOnSemicolon = BNFAddArticle(NAMESPACE_BNF, "BNFstopOnSemicolon");
	*bnfStopOnSemicolon
		>=true >=";" >"BNFwhite" >BNFcode("BNFend") >=false
		<=false >=0 <=0
 	;

	static const String BNF_ID_DELIM = " *;|()[]{}\"<>:\n\r\t";
	bnfScheme = BNFAddArticle(NAMESPACE_BNF, "BNFscheme");
	*bnfScheme
		>=false >"BNFwhite" >=true 
			<=true >="<"  >BNFcode("BNFstr",BNF_ID_DELIM) >="::"> BNFcode("BNFstr",BNF_ID_DELIM)  >BNFcode("BNFnonterm_end")  >=">" <=0
			<=true >="<"  >BNFcode("BNFstr10",NAMESPACE_BNF) >BNFcode("BNFstr",BNF_ID_DELIM)  >BNFcode("BNFnonterm_end")  >=">" <=0
			<=true >="\"\"" >BNFcode("BNFstr10","") <=0
			<=true >="\"" >BNFcode("BNFstr","\"") >BNFcode("BNFterm_end")    >="\"" <=0
			<=true >="{"  >"BNFwhite" >BNFcode("BNFrepeat") >"BNFscheme" >BNFcode("BNFrepeat_end") >"BNFwhite" >="}" <=0
			<=true >="["  >"BNFwhite" >BNFcode("BNFoption") >"BNFscheme" >BNFcode("BNFoption_end") >"BNFwhite" >="]" <=0
			<=true >="("  >"BNFwhite" >BNFcode("BNFgroup")  >"BNFscheme" >BNFcode("BNFgroup_end")  >"BNFwhite" >=")" <=0
			<=true >="|"  >"BNFwhite" >BNFcode("BNFbranch") >"BNFscheme" >BNFcode("BNFbranch_end")       <=0
			<=true        >BNFcode("BNFstr",BNF_ID_DELIM) >BNFcode("BNFrv",0) >BNFcode("BNFcode_end") <=0
			<=true        >BNFcode("BNFstr",BNF_ID_DELIM) >"BNFwhite" >=":" >"BNFwhite" >"BNFarg" >BNFcode("BNFcode_end") <=0
		>"BNFstopOnSemicolon"
	;
}

//----------------------------------------------------------------------------------------------
/* CRC Table High byte */
byte CRC_Hi[] = {
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40
} ;
//-----------------------------------------------------------------------
/* CRC Table Low byte */
byte CRC_Lo[] = {
0x00, 0xC0, 0xC1, 0x01, 0xC3, 0x03, 0x02, 0xC2,
0xC6, 0x06, 0x07, 0xC7, 0x05, 0xC5, 0xC4, 0x04,
0xCC, 0x0C, 0x0D, 0xCD, 0x0F, 0xCF, 0xCE, 0x0E,
0x0A, 0xCA, 0xCB, 0x0B, 0xC9, 0x09, 0x08, 0xC8,
0xD8, 0x18, 0x19, 0xD9, 0x1B, 0xDB, 0xDA, 0x1A,
0x1E, 0xDE, 0xDF, 0x1F, 0xDD, 0x1D, 0x1C, 0xDC,
0x14, 0xD4, 0xD5, 0x15, 0xD7, 0x17, 0x16, 0xD6,
0xD2, 0x12, 0x13, 0xD3, 0x11, 0xD1, 0xD0, 0x10,
0xF0, 0x30, 0x31, 0xF1, 0x33, 0xF3, 0xF2, 0x32,
0x36, 0xF6, 0xF7, 0x37, 0xF5, 0x35, 0x34, 0xF4,
0x3C, 0xFC, 0xFD, 0x3D, 0xFF, 0x3F, 0x3E, 0xFE,
0xFA, 0x3A, 0x3B, 0xFB, 0x39, 0xF9, 0xF8, 0x38,
0x28, 0xE8, 0xE9, 0x29, 0xEB, 0x2B, 0x2A, 0xEA,
0xEE, 0x2E, 0x2F, 0xEF, 0x2D, 0xED, 0xEC, 0x2C,
0xE4, 0x24, 0x25, 0xE5, 0x27, 0xE7, 0xE6, 0x26,
0x22, 0xE2, 0xE3, 0x23, 0xE1, 0x21, 0x20, 0xE0,
0xA0, 0x60, 0x61, 0xA1, 0x63, 0xA3, 0xA2, 0x62,
0x66, 0xA6, 0xA7, 0x67, 0xA5, 0x65, 0x64, 0xA4,
0x6C, 0xAC, 0xAD, 0x6D, 0xAF, 0x6F, 0x6E, 0xAE,
0xAA, 0x6A, 0x6B, 0xAB, 0x69, 0xA9, 0xA8, 0x68,
0x78, 0xB8, 0xB9, 0x79, 0xBB, 0x7B, 0x7A, 0xBA,
0xBE, 0x7E, 0x7F, 0xBF, 0x7D, 0xBD, 0xBC, 0x7C,
0xB4, 0x74, 0x75, 0xB5, 0x77, 0xB7, 0xB6, 0x76,
0x72, 0xB2, 0xB3, 0x73, 0xB1, 0x71, 0x70, 0xB0,
0x50, 0x90, 0x91, 0x51, 0x93, 0x53, 0x52, 0x92,
0x96, 0x56, 0x57, 0x97, 0x55, 0x95, 0x94, 0x54,
0x9C, 0x5C, 0x5D, 0x9D, 0x5F, 0x9F, 0x9E, 0x5E,
0x5A, 0x9A, 0x9B, 0x5B, 0x99, 0x59, 0x58, 0x98,
0x88, 0x48, 0x49, 0x89, 0x4B, 0x8B, 0x8A, 0x4A,
0x4E, 0x8E, 0x8F, 0x4F, 0x8D, 0x4D, 0x4C, 0x8C,
0x44, 0x84, 0x85, 0x45, 0x87, 0x47, 0x46, 0x86,
0x82, 0x42, 0x43, 0x83, 0x41, 0x81, 0x80, 0x40
};
word __modbus_crc(const char *buf, int l)
{
	byte index;
	byte crcHi = 0xFF;
	byte crcLo = 0xFF;
	for (int i=0; i<l; ++i)
	{
		index = crcHi ^ buf[i];
		crcHi = crcLo ^ CRC_Hi[index];
		crcLo =         CRC_Lo[index];
	}
	
	return (((word) crcLo) << 8) | crcHi;
}

byte __wake_crc(const Vector<byte> &bytes)
{
	byte out = 0;
	
	for (int n=0; n<bytes.GetCount(); ++n)
	{
		byte b = bytes[n];
		out += b;
	}
	
	return out;
}

byte M0803CRC[] = {
0x00,0x5e,0xbc,0xe2,0x61,0x3f,0xdd,0x83,0xc2,0x9c,0x7e,0x20,0xa3,0xfd,0x1f,0x41,
0x9d,0xc3,0x21,0x7f,0xfc,0xa2,0x40,0x1e,0x5f,0x01,0xe3,0xbd,0x3e,0x60,0x82,0xdc,
0x23,0x7d,0x8f,0xc1,0x42,0x1c,0xfe,0xa0,0xe1,0xbf,0x5d,0x03,0x80,0xde,0x3c,0x62,
0xbe,0xe0,0x02,0x5c,0xdf,0x81,0x63,0x3d,0x7c,0x22,0xc0,0x9e,0x1d,0x43,0xa1,0xff,
0x46,0x18,0xfa,0xa4,0x27,0x79,0x9b,0xc5,0x84,0xda,0x38,0x66,0xe5,0xbb,0x59,0x07,
0xdb,0x85,0x67,0x39,0xba,0xe4,0x06,0x58,0x19,0x47,0xa5,0xfb,0x78,0x26,0xc4,0x9a,
0x65,0x3b,0xd9,0x87,0x04,0x5a,0xb8,0xe6,0xa7,0xf9,0x1b,0x45,0xc6,0x98,0x7a,0x24,
0xf8,0xa6,0x44,0x1a,0x99,0xc7,0x25,0x7b,0x3a,0x64,0x86,0xd8,0x5b,0x05,0xe7,0xb9,
0x8c,0xd2,0x30,0x6e,0xed,0xb3,0x51,0x0f,0x4e,0x10,0xf2,0xac,0x2f,0x71,0x93,0xcd,
0x11,0x4f,0xad,0xf3,0x70,0x2e,0xcc,0x92,0xd3,0x8d,0x6f,0x31,0xb2,0xec,0x0e,0x50,
0xaf,0xf1,0x13,0x4d,0xce,0x90,0x72,0x2c,0x6d,0x33,0xd1,0x8f,0x0c,0x52,0xb0,0xee,
0x32,0x6c,0x8e,0xd0,0x53,0x0d,0xef,0xb1,0xf0,0xae,0x4c,0x12,0x91,0xcf,0x2d,0x73,
0xca,0x94,0x76,0x28,0xab,0xf5,0x17,0x49,0x08,0x56,0xb4,0xea,0x69,0x37,0xd5,0x8b,
0x57,0x09,0xeb,0xb5,0x36,0x68,0x8a,0xb4,0x95,0xcb,0x29,0x77,0xf4,0xaa,0x48,0x16,
0xe9,0xb7,0x55,0x0b,0x88,0xd6,0x34,0x6a,0x2b,0x75,0x97,0xc9,0x4a,0x14,0xf6,0xa8,
0x74,0x2a,0xc8,0x96,0x15,0x4b,0xa9,0xf7,0xb6,0xe8,0x0a,0x54,0xd7,0x89,0x6b,0x35
};
byte __m0803_crc(const Vector<byte> &bytes)
{
	byte crc = 0;
	for (int i=0; i<bytes.GetCount(); ++i)
	{
		byte b = bytes[i];
		byte n = crc ^ b;
		crc = M0803CRC[n];
	}
	
	return crc;
}
//-----------------------------------------------------------------------
