#ifndef _SerialPort_SerialPort_h_
#define _SerialPort_SerialPort_h_

#include <Core/Core.h>
#include <MtAlt/MtAlt.h>
#include <BNF/BNF/BNF.h>
#include "crossplatserial/crossserial.h"
using namespace Upp;

#define SERIAL_LOG   LOG
#define NAMESPACE_IO String("IO")

template <class QUEUE_CLASS>
class SerialPortNotify : public Pte<SerialPortNotify<QUEUE_CLASS> >, public QUEUE_CLASS
{
public:
	SerialPortNotify(int cnt = 10000
		#ifdef _DEBUG
		, SourcePosition sp = SourcePosition()
		#endif
	)
	{
	}
	virtual ~SerialPortNotify<QUEUE_CLASS>()
	{
		//LOG("~SerialPortNotify");
	}
};

class SerialPort : public CallbackThread
{
public:
	SerialPort(const String &device) throw (Exc);
	~SerialPort();
	void Init(uint32_t baud, char parity, uint8_t dataBits, uint8_t stopBits);
	
public:
	template<class OBJECT>
	void SendReceive_
	(
		String         sendProto,
		Vector<Value>  sendArgs,
		String         receiveProto,
		dword          timeout,
		void          *custom,
		Ptr<OBJECT>    notify,
		void (OBJECT::*cb)(bool success, Vector<Value> args, void *custom),
		bool           useAcc = false,
		bool           priority = false
	)
	{
		Request<SerialPort, SendReceiveArgs<OBJECT> >
		(
			&SerialPort::SendReceive<OBJECT>,
			SendReceiveArgs<OBJECT>
			(
				sendProto,
				sendArgs,
				receiveProto,
				timeout,
				custom,
				notify,
				cb,
				useAcc,
				priority
			),
			NULL,
			(priority ? 1 : 0)
		);
	}
	void SendReceiveSleep_(int ms)
	{
		if (ms > 0)
			Request(&SerialPort::SendReceiveSleep, ms);
	}
	
public:
	//поддержка списка портов из файла ports
	static void OpenPorts();
	static void ClosePorts();
	static void BNFInit();
	static SerialPort *GetPort(const String &);
	
private:
	template <class OBJECT>
	struct SendReceiveArgs
	{
		String                 sendProto;
		Vector<Value>          sendArgs;
		String                 receiveProto;
		dword                  timeout;
		void                  *custom;
		Ptr<OBJECT>            notify;
		void (OBJECT::*cb)(bool success, Vector<Value> args, void *custom);
		bool                   useAcc;
		bool                   priority;
		
		SendReceiveArgs(){}
		SendReceiveArgs
		(
			String         _sendProto,
			Vector<Value>  _sendArgs,
			String         _receiveProto,
			dword          _timeout,
			void          *_custom,
			Ptr<OBJECT>    _notify,
			void (OBJECT::*_cb)(bool success, Vector<Value> args, void *custom),
			bool           _useAcc,
			bool           _priority = false
		)
			:sendProto   (_sendProto)
			,sendArgs    (_sendArgs)
			,receiveProto(_receiveProto)
			,timeout     (_timeout)
			,custom      (_custom)
			,notify      (_notify)
			,cb          (_cb)
			,useAcc      (_useAcc)
			,priority    (_priority)
		{}
	};
	template<class OBJECT>
	inline void SendReceive(SendReceiveArgs<OBJECT> args)
	{
		#ifdef _DEBUG
		{
			static dword t0 = 0;
			dword t = GetTickCount();
			if (t - t0 > 5000)
			{
				SERIAL_LOG(Format("%02d.%03d .. (%s): #%d",(int)(GetTickCount()/1000)%100,(int)(GetTickCount()%1000),FormatPtr(this),CallbackQueue::GetTasksCount()));
				t0 = t;
			}
		}
		#endif

		BNFarticles &bnfArticles = bnfNamespaces.GetAdd(NAMESPACE_IO);
		void (OBJECT::*cb)(bool,Vector<Value>, void *);
		cb = args.cb;
		
		int articleI = 0;
		if (!args.sendProto.IsEmpty())
		{
			articleI = GetProtoICached(bnfArticles, args.sendProto);
			if (articleI < 0)
			{
				if (~args.notify)
					(~args.notify)->Request<OBJECT,bool,Vector<Value>,void *>(cb, false, Vector<Value>(), args.custom);
				return;
			}
		
			GenState state;
			state.inValues = args.sendArgs;
			if (!bnfArticles[articleI].Gen(&state))
			{
				if (~args.notify)
					(~args.notify)->Request<OBJECT,bool,Vector<Value>,void *>(cb, false, Vector<Value>(), args.custom);
				return;
			}
			
			if (!state.state.outData.IsEmpty())
			{
				if (SerialTimeouts(&port, args.timeout/10) != SERIAL_OK)
				{
					if (~args.notify)
						(~args.notify)->Request<OBJECT,bool,Vector<Value>,void *>(cb, false, Vector<Value>(), args.custom);
					return;
				}
				//SERIAL_LOG(Format("%02d.%03d << %25s ",(int)(GetTickCount()/1000)%100,(int)(GetTickCount()%1000),args.sendProto)+NormalizeString(state.state.outData));
				int32_t written = 0;
				if
				(
					SerialWrite(&port, reinterpret_cast<const uint8_t *>(~state.state.outData), state.state.outData.GetLength(), &written) != SERIAL_OK
				||  written != state.state.outData.GetLength()
				)
				{
					if (~args.notify)
						(~args.notify)->Request<OBJECT,bool,Vector<Value>,void *>(cb, false, Vector<Value>(), args.custom);
					return;
				}
			}
		}

		ParseState parseState;
		parseState.inData = acc;
		{
			int att = 0;
			while (++att < 50)
			{
				if (SerialTimeouts(&port,1) == SERIAL_OK)
					break;
			}
			parseState.inData.Reserve(32);
			articleI = GetProtoICached(bnfArticles, args.receiveProto);
		}
		
		bool  isParsed = false;
		dword t0 = GetTickCount();
		int dataSizeOld = 0;
		//String testFailed = args.receiveProto + '#';

		if (!args.useAcc || acc.GetLength() > 8)
			acc.Clear();
		//testFailed += acc;
		
		while (GetTickCount() - t0 < args.timeout)
		{
			if (acc.GetLength() > dataSizeOld)
			{
				dataSizeOld = acc.GetLength();
				
				Index<String> &failedCache = failedCaches.GetAdd(articleI);
				if (failedCache.Find(acc) < 0)
				{
					int i=0;
					for (int i=0; i<(args.useAcc ? acc.GetLength() : 1); ++i) 
					{
						parseState.inData = acc.Mid(i);
						parseState.state.Clear();
	
						if (bnfArticles[articleI].Parse(&parseState))
						{
							//SERIAL_LOG(Format("%02d.%03d >> %25s ",(int)(GetTickCount()/1000)%100,(int)(GetTickCount()%1000),args.receiveProto)+NormalizeString(parseState.inData.Left(parseState.state.inOffset)));
							if (~args.notify)
								(~args.notify)->Request<OBJECT,bool,Vector<Value>,void *>(cb, true, parseState.state.values, args.custom);
							
							int smallestParsedCacheI = smallestParsedCache.FindAdd(args.receiveProto,100000000);
							if (smallestParsedCache[smallestParsedCacheI] > parseState.state.inOffset)
								smallestParsedCache[smallestParsedCacheI] = parseState.state.inOffset;
							acc.Clear();
							isParsed = true;
							break;
						}
						if (isParsed)
							break;
						failedCache << acc;
						if (failedCache.GetCount() > 100000)
							failedCache.Remove(0);
					}
				}
			}

			int32_t read = 0;
			int smallestParsedCacheI = smallestParsedCache.Find(args.receiveProto);
			if (smallestParsedCacheI >= 0 && acc.GetLength() < smallestParsedCache[smallestParsedCacheI])
				SerialRead(&port, &data[0], smallestParsedCache[smallestParsedCacheI]-acc.GetLength(), &read);
			else
				SerialRead(&port, &data[0], 1, &read);
			if (read)
			{
				acc       .Cat((const char *) &data[0], read);
				//testFailed.Cat((const char *) &data[0], read);
			}
		}
		
		//timeout
		if (!isParsed && ~args.notify)
		{
			//SERIAL_LOG(Format("%02d.%03d !> %25s ",(int)(GetTickCount()/1000)%100,(int)(GetTickCount()%1000),args.receiveProto)+NormalizeString(parseState.inData.IsEmpty() ? String() : parseState.inData));
			(~args.notify)->Request<OBJECT,bool,Vector<Value>,void *>(cb, false, Vector<Value>(), args.custom);
		}
	}
	
	String NormalizeString(String s)
	{
		String hex;
		for (int i=0; i<s.GetLength(); ++i)
		{
			hex << Format(" %02X", s[i] & 0xFF);
			if (s[i] < ' ' || s[i] > 0x7E)
				s.Set(i,'.');
		}
		return Format("%-16s", s)+" | "+hex;
	}
	
	void SendReceiveSleep(int ms)
	{
		if (ms > 0)
			Sleep(ms);
	}
	
	int GetProtoICached(BNFarticles &, const String &name);

	serialPort_t port;
	VectorMap<String, Uuid> protocolCache;

private:
	static ArrayMap<String, SerialPort> portsMap;
	uint8_t data[10240];
	String acc;
	VectorMap<int,Index<String> > failedCaches;
	VectorMap<String,int> smallestParsedCache;
	#ifdef _DEBUG
	dword __t0;
	#endif
};

#endif
