#include "ManualPosition.h"

ManualPosition::ManualPosition()
{
	CtrlLayout(*this, "Manual Position Example (resize window)");

	Zoomable().Sizeable();

	ctrl_init();
}


void ManualPosition::ctrl_init(void)
{
	// Initialise control details.
	ed_htype.SetData(0);
	ed_hp1.SetData(10);
	ed_hp2.SetData(50);

	ed_vtype.SetData(0);
	ed_vp1.SetData(10);
	ed_vp2.SetData(50);

	// Add custom floating frame.
	ctrl_box.Add(ctrl_float);
	ctrl_float.SetFrame(BlackFrame());
	ctrl_update();

	ed_htype.InitFocus();

	// Trigger updating control settings when things change.
	ed_htype 	<<= THISBACK(ctrl_update);
	ed_hp1 		<<= THISBACK(ctrl_update);
	ed_hp2 		<<= THISBACK(ctrl_update);

	ed_vtype 	<<= THISBACK(ctrl_update);
	ed_vp1	 	<<= THISBACK(ctrl_update);
	ed_vp2 		<<= THISBACK(ctrl_update);
}

void ManualPosition::ctrl_update(void)
{
	// Update the control details.
	switch( ed_htype )
	{
		case 0:
			ctrl_float.LeftPos( ed_hp1.GetData(), ed_hp2.GetData() );
			break;

		case 1:
			ctrl_float.RightPos( ed_hp1.GetData(), ed_hp2.GetData() );
			break;

		case 2:
			ctrl_float.HSizePos( ed_hp1.GetData(), ed_hp2.GetData() );
			break;

		case 3:
			ctrl_float.HCenterPos( ed_hp1.GetData(), ed_hp2.GetData() );
			break;
	}


	switch( ed_vtype )
	{
        case 0:
            ctrl_float.TopPos( ed_vp1.GetData(), ed_vp2.GetData() );
            break;

        case 1:
            ctrl_float.BottomPos( ed_vp1.GetData(), ed_vp2.GetData() );
            break;

        case 2:
            ctrl_float.VSizePos( ed_vp1.GetData(), ed_vp2.GetData() );
            break;

        case 3:
            ctrl_float.VCenterPos( ed_vp1.GetData(), ed_vp2.GetData() );
            break;
	}

}


GUI_APP_MAIN
{
	ManualPosition().Run();
}

