#include <Core/Core.h>
#include <CtrlLib/CtrlLib.h>
#include <Sql/Sql.h>
#include <Oracle/Oracle8.h>

using namespace Upp;

#define SCHEMADIALECT <Oracle/OracleSchema.h>
#define MODEL <TestOraUTF8Error/db.sch>
#include <Sql/sch_header.h>
#include <Sql/sch_schema.h>
#include <Sql/sch_source.h>


#define LAYOUTFILE <TestOraUTF8Error/layout.lay>
#include <CtrlCore/lay.h>

class UTF8Error : public WithUTF8ErrorLayout<TopWindow>
{
public:
	Value in1,in2;

	typedef UTF8Error CLASSNAME;
	UTF8Error();
	
	void save();
	
};

UTF8Error::UTF8Error()
{
	CtrlLayout(*this, "UTF8Error");
	btnsave << THISBACK(save);
	input1.SetData("äääää");
	input2.SetData("äääää");
}
void UTF8Error::save()
{
	int count;
	PromptOK("Save -> please see LOG");
	LOG("input1:");
	LOG(input1.GetData());
	in1 = input1.GetData();

	LOG("input2:");
	LOG(input2.GetData());
	in2 = input2.GetData();
	
	/*
	TABLE_(UTF8TEST) 
		INT_     (ID) PRIMARY_KEY
		STRING_  (TEST1,5)
		STRING_  (TEST2,10)
		TIME     (TSTAMP)
	END_TABLE
	*/
	
	SQL * Select(SqlMax(ID)).From(UTF8TEST);
	if (SQL.Fetch())
		count = SQL[0];
	
	if (count <0)
		count = 0;
	
	SQL * SqlInsert(UTF8TEST)(ID,++count)(TEST1,in1)(TSTAMP,GetSysTime());
	LOG("Insert("+AsString(count)+"): "+ SQL.ToString());
	
	SQL * Select(TEST1).From(UTF8TEST).Where(ID == count);
	if (SQL.Fetch())
		output1.SetData(SQL[0]);
	

	SQL * SqlInsert(UTF8TEST)(ID,++count)(TEST2,in2)(TSTAMP,GetSysTime());
	LOG("Insert("+AsString(count)+"): "+ SQL.ToString());
	
	SQL * Select(TEST2).From(UTF8TEST).Where(ID == count);
	if (SQL.Fetch())
		output2.SetData(SQL[0]);

	
	SQL.Commit();
}
GUI_APP_MAIN
{
	Oracle8 * oracle = NULL;
	oracle = new Oracle8();
	Upp::String db_open;
	db_open = "SCOTT/TIGER@DEMO";
	oracle->Open(db_open ,  false);
	
	LOG("UTF8 Database? " +AsString(oracle->IsUtf8Session() ? "true" : "false" ));
	if (!oracle->IsOpen()){
	    PromptOK("Database: Connection?");
	    return;
	}
	oracle->SetTransactionMode(Oracle8::ORACLE);
	oracle->SetTrace();
	oracle->LogErrors(true);

	SQL = *oracle;

	StdStatementExecutor se(SQL.GetSession());
	SqlSchema sch(ORACLE);
	All_Tables(sch);	
	OraclePerformScript(sch.Upgrade(), se);
	OraclePerformScript(sch.Attributes(), se);

	UTF8Error test;
	test.Run();
	delete oracle;
}

