TITLE("Ptr and Pte")
REF("::PteBase::class")
REF("::PteBase::HasUuid()")
REF("::PteBase::GetUuid()")
REF("::PteBase::SetUuid(const::Uuid&)")
REF("::PteBase::SerializePte(::Stream&)")
REF("::Pte::class")
REF("::PtrBase::PtrBase()")
REF("::PtrBase::~PtrBase()")
REF("::PtrBase::HasUuid()")
REF("::PtrBase::GetUuid()")
REF("::PtrBase::SetUuid(const::Uuid&)")
REF("::PtrBase::Serialize(::Stream&)")
REF("::Ptr::class")
REF("::Ptr::Ptr()")
REF("::Ptr::Ptr(T*)")
REF("::Ptr::Ptr(const::Ptr&)")
REF("::Ptr::operator->()const")
REF("::Ptr::operator~()const")
REF("::Ptr::operator T*()const")
REF("::Ptr::operator=(T*)")
REF("::Ptr::operator=(const::Ptr&)")
REF("::Ptr::operator==(const::Ptr&,const T*)")
REF("::Ptr::operator==(const T*,const::Ptr&)")
REF("::Ptr::operator==(const::Ptr&,const::Ptr&)")
REF("::Ptr::operator==(const::Ptr&,T*)")
REF("::Ptr::operator==(T*,const::Ptr&)")
REF("::Ptr::operator!=(const::Ptr&,const T*)")
REF("::Ptr::operator!=(const T*,const::Ptr&)")
REF("::Ptr::operator!=(const::Ptr&,const::Ptr&)")
REF("::Ptr::ToString()const")
TOPIC_TEXT(
"[2 $$0,0#00000000000000000000000000000000:Default][l288;i1120;a17;O9;~~~.1408;2 "
"$$1,0#10431211400427159095818037425705:param][a83;*R6 $$2,5#31310162474203024125188417583966:caption][b83;*4 "
"$$3,5#07864147445237544204411237157677:title][i288;O9;C2 $$4,6#40027414424643823182269349404212:item][b42;a42;2 "
"$$5,5#45413000475342174754091244180557:text][l288;b17;a17;2 $$6,6#27521748481378242620020725143825:")
TOPIC_TEXT(
"desc][l321;t246;C@5;1 $$7,7#20902679421464641399138805415013:code][b2503; $$8,0#65142375456100023862071332075487:separator][*@(0.0.255)2 "
"$$9,0#83433469410354161042741608181528:base][t4167;C $$10,0#37138531426314131251341829483380:class][l288;a17;*1 "
"$$11,11#70004532496200323422659154056402:requirement][i417;b42;a42;O9;~~~.416;2 $$12,12#10566046415157235020018451313112:tparam][b167;C2 "
"$$13,13#924304")
TOPIC_TEXT(
"59443460461911108080531343:item1][i288;a42;O9;C2 $$14,14#77422149456609303542238260500223:item2][*@2$(0.128.128) "
"$$15,15#34511555403152284025741354420178:NewsDate][l321;*C$7;2 $$16,16#03451589433145915344929335295360:result][l321;b83;a83;*C$7;2 "
"$$17,17#07531550463529505371228428965313:result`-line][l160;t4167;*C+117 $$18,5#88603949442205825958800053222425:package`-title][ "
"$$19,0#535800234423355290")
TOPIC_TEXT(
"39900623488521:gap][t4167;C2 $$20,20#70211524482531209251820423858195:class`-nested][b50;2 "
"$$21,21#03324558446220344731010354752573:Par][{_}%EN-US [s2; Ptr and Pte&][s5; Ptr "
"and Pte class templates provide a smart pointer system that has two unique characteristics:&][s5;i150;O2; "
"Pointers are cleared when pointed object is destructed. That makes it useful in situations "
"where life`-time of object ca")
TOPIC_TEXT(
"nnot be precisely determined.&][s5;i150;O2; Pointers have persistence features. "
"When both pointer and object that pointer points to are serialized out and back in, "
"Ptr restores its value and again points to the same object. This persistence is achieved "
"using universally unique identifiers (UUID). Pointer `- pointed object relations "
"are determined based on this value.&][s5; While Ptr class template")
TOPIC_TEXT(
" provides smart pointers, Pte is the class which adds necessary functionality to "
"pointed objects. Ptr could only point to objects of Pte`-derived type. So to make "
"a class `\"Ptr`-able`\" you should add Pte as one of class bases, with the derived "
"class as its parameter, e.g.:&][s5; struct Foo : Pte<Foo> `{....&][s5; &][s5; Persistence "
"features are implemented in a way that has zero performance impact")
TOPIC_TEXT(
" when not used.&][s5;/ &][s10;:`:`:PteBase`:`:class:* [* class_]PteBase&][s0;3 &][s0;* "
"&][s6; This class contains all functionality of Pte that is not type specific.&][s0;3 "
"&][s4;:`:`:PteBase`:`:HasUuid`(`): bool_[* HasUuid]()&][s1; [*/ Return value]-|Returns "
"true if Pte has assigned UUID.&][s0;3 &][s4;:`:`:PteBase`:`:GetUuid`(`): const_Uuid`&_[* "
"GetUuid]()&][s1; [*/ Return value]-|Returns UUID va")
TOPIC_TEXT(
"lue for pointed object. If it does not have one yet, new UUID is assigned.&][s0;3 "
"&][s4;:`:`:PteBase`:`:SetUuid`(const`:`:Uuid`&`): void_[* SetUuid](const_Uuid`&_[*@3 "
"uuid])&][s6; Sets pointed object`'s UUID. Pointed object should not have any UUID "
"assigned at this moment.&][s1; [*C@3 uuid]-|required uuid.&][s0;3 &][s4;:`:`:PteBase`:`:SerializePte`(`:`:Stream`&`): "
"void_[* SerializePte](Stream`&_[*")
TOPIC_TEXT(
"@3 s])&][s6; Serializes necessary information (UUID) for pointed object to the Stream.&][s1; "
"[*C@3 s]-|Stream.&][s5; &][s5; &][s0;3 &][s10;:`:`:Pte`:`:class: template_<class_[*@4 "
"T]>&][s10;* [* class_]Pte&][s0;3 &][s0;* &][s6; This template class implements the "
"functionality needed in the pointed object.  &][s12; [*C@4 T]-|Type of pointed object.&][s9;^topic`:`/`/Core`/src`/PtePtr`$en`-us`#`:`:Pte")
TOPIC_TEXT(
"Base`:`:class PteBase^ [/^^ Derived from][^^  ]PteBase&][s5; &][s5; &][s10;* [* "
"class_]PtrBase&][s0;* &][s6; This class contains all functionality of Ptr that is "
"not type`-specific.&][s0;3 &][s4;:`:`:PtrBase`:`:PtrBase`(`): [* PtrBase]()&][s6; "
"Constructor. Constructs NULL Ptr.&][s0;3 &][s4;:`:`:PtrBase`:`:`~PtrBase`(`): `~[* "
"PtrBase]()&][s6; Destructor.&][s0;3 &][s4;:`:`:PtrBase`:`:HasUuid`(`): bo")
TOPIC_TEXT(
"ol_[* HasUuid]()&][s1; [*/ Return value]-|true if object pointed by this object "
"has UUID assigned.&][s0;3 &][s4;:`:`:PtrBase`:`:GetUuid`(`): Uuid_[* GetUuid]()&][s1; "
"[*/ Return value]-|UUID of pointed object. If pointed object does not have one, new "
"one is generated and assigned.&][s0;3 &][s4;:`:`:PtrBase`:`:SetUuid`(const`:`:Uuid`&`): "
"void_[* SetUuid](const_Uuid`&_[*@3 uuid])&][s1; [*C@3 uuid]-|S")
TOPIC_TEXT(
"ets UUID to pointer. If there is some object with the same UUID, pointer will point "
"to it. Otherwise it will be NULL until some such object appears.&][s0;3 &][s4;:`:`:PtrBase`:`:Serialize`(`:`:Stream`&`): "
"void_[* Serialize](Stream`&_[*@3 s])&][s6; Serializes pointer to stream (in fact, "
"its UUID).&][s1; [*C@3 s]-|Stream.&][s0;3 &][s5; &][s10;:`:`:Ptr`:`:class: template_<class_[*@4 "
"T]>&][s10;* [* cl")
TOPIC_TEXT(
"ass_]Ptr&][s0;3 &][s0;* &][s6; Type specific pointer.&][s12; [*C@4 T]-|Type of pointed "
"object. T class must be derived from Pte<T>.&][s9;^topic`:`/`/Core`/src`/PtePtr`$en`-us`#`:`:PtrBase`:`:PtrBase`(`)^ "
"[/^^ Derived from][^^  ]PtrBase&][s0;3 &][s4;:`:`:Ptr`:`:Ptr`(`): [* Ptr]()&][s6; "
"Default constructor.&][s0;3 &][s4;:`:`:Ptr`:`:Ptr`(T`*`): [* Ptr](T_`*[*@3 ptr])&][s6; "
"Constructs Ptr pointing to ")
TOPIC_TEXT(
"specified object.&][s1; [*C@3 ptr]-|C`+`+ pointer to pointed object.&][s0;3 &][s4;:`:`:Ptr`:`:Ptr`(const`:`:Ptr`&`): "
"[* Ptr](const_[* Ptr]`&_[*@3 ptr])&][s6; Constructs Ptr pointing to the same object "
"as other Ptr.&][s1; [*C@3 ptr]-|Other Ptr.&][s0;3 &][s4;:`:`:Ptr`:`:operator`-`>`(`)const: "
"T_`*[* operator`->]()_const&][s1; [*/ Return value]-|C`+`+ pointer to pointed object "
"or NULL if Ptr does not")
TOPIC_TEXT(
" point to any object.&][s0;3 &][s4;:`:`:Ptr`:`:operator`~`(`)const: T_`*[* operator`~]()_const&][s1; "
"[*/ Return value]-|C`+`+ pointer to pointed object or NULL if Ptr does not point "
"to any object.&][s0;3 &][s4;:`:`:Ptr`:`:operator T`*`(`)const: [* operator_T`*]()_const&][s1; "
"[*/ Return value]-|C`+`+ pointer to pointed object or NULL if Ptr does not point "
"to any object.&][s0;3 &][s4;:`:`:Ptr`:`:ope")
TOPIC_TEXT(
"rator`=`(T`*`): Ptr`&_[* operator`=](T_`*[*@3 ptr])&][s6; Assigns new pointer.&][s1; "
"[*C@3 ptr]-|Pointer.&][s1; [*/ Return value]-|`*this.&][s0;3 &][s4;:`:`:Ptr`:`:operator`=`(const`:`:Ptr`&`): "
"Ptr`&_[* operator`=](const_Ptr`&_[*@3 ptr])&][s6; Assigns other Ptr.&][s1; [*C@3 "
"ptr]-|&][s1; [*/ Return value]-|&][s0;3 &][s4;:`:`:Ptr`:`:operator`=`=`(const`:`:Ptr`&`,const "
"T`*`): friend_bool_[* operator`")
TOPIC_TEXT(
"=`=](const_Ptr`&_[*@3 a], const_T_`*[*@3 b])&][s4;:`:`:Ptr`:`:operator`=`=`(const "
"T`*`,const`:`:Ptr`&`): friend_bool_[* operator`=`=](const_T_`*[*@3 a], const_Ptr`&_[*@3 "
"b])&][s4;:`:`:Ptr`:`:operator`=`=`(const`:`:Ptr`&`,const`:`:Ptr`&`): friend_bool_[* "
"operator`=`=](const_Ptr`&_[*@3 a], const_Ptr`&_[*@3 b])&][s4;:`:`:Ptr`:`:operator`=`=`(const`:`:Ptr`&`,T`*`): "
"friend_bool_[* operator`=`=](const_P")
TOPIC_TEXT(
"tr`&_[*@3 a], T_`*[*@3 b])&][s4;:`:`:Ptr`:`:operator`=`=`(T`*`,const`:`:Ptr`&`): "
"friend_bool_[* operator`=`=](T_`*[*@3 a], const_Ptr`&_[*@3 b])&][s4;:`:`:Ptr`:`:operator`!`=`(const`:`:Ptr`&`,const "
"T`*`): friend_bool_[* operator!`=](const_Ptr`&_[*@3 a], const_T_`*[*@3 b])&][s4;:`:`:Ptr`:`:operator`!`=`(const "
"T`*`,const`:`:Ptr`&`): friend_bool_[* operator!`=](const_T_`*[*@3 a], const_Ptr`&_[*@3 "
"b])&")
TOPIC_TEXT(
"][s4;:`:`:Ptr`:`:operator`!`=`(const`:`:Ptr`&`,const`:`:Ptr`&`): friend_bool_[* "
"operator!`=](const_Ptr`&_[*@3 a], const_Ptr`&_[*@3 b])&][s6; Comparison operators.&][s0;3 "
"&][s4;:`:`:Ptr`:`:ToString`(`)const: String_[* ToString]()_const&][s6; Converts all "
"information to string for diagnostic purposes&][s1; [*/ Return value]-|Text.&][s0;3 "
"]")
