#include "Esc.h"


NAMESPACE_UPP

EscValue EscFromStdValue(const Value& v)
{
	EscValue r;
	Time t;
	if(!IsNull(v))
		switch(v.GetType()) {
		case BOOL_V:
		case INT_V:
		case INT64_V:
		case DOUBLE_V:
			r = (double)v;
			break;
		case STRING_V:
		case WSTRING_V:
			r = (String)v;
			break;
		case TIME_V:
			t = v;
			r.MapSet(L"hour", t.hour);
			r.MapSet(L"minute", t.minute);
			r.MapSet(L"second", t.second);
		case DATE_V:
			t = v;
			r.MapSet(L"year", t.year);
			r.MapSet(L"month", t.month);
			r.MapSet(L"day", t.day);
			break;
		case VALUEARRAY_V:
			ValueArray va = v;
			r.SetEmptyArray();
			for(int i = 0; i < va.GetCount(); i++)
				r.ArrayAdd(EscFromStdValue(va[i]));
		}
	return r;
}

Value StdValueFromEsc(const EscValue& v)
{
	if(v.IsNumber())
		return v.GetNumber();
	if(v.IsArray())
		return (String)v;
	if(IsTime(v))
		return Time(v.GetFieldInt(L"year"), v.GetFieldInt(L"month"), v.GetFieldInt(L"day"),
			v.GetFieldInt(L"hour"), v.GetFieldInt(L"minute"), v.GetFieldInt(L"second"));
	if(IsDate(v))
		return Date(v.GetFieldInt(L"year"), v.GetFieldInt(L"month"), v.GetFieldInt(L"day"));
	return Value();
}

void SIC_StdFormat(EscEscape& e)
{
	e = StdFormat(StdValueFromEsc(e[0]));
}

void StdValueLib(ArrayMap<String, EscValue>& global)
{
	Escape(global, L"StdFormat(x)", SIC_StdFormat);
}

END_UPP_NAMESPACE
