#include "gl_struct1.h"
#include "gl_struct.h"

void gl_struct1::GLInit()
{
		
	glClearColor(1.0f, 1.0f, 1.0f, 1.0f );
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	Refresh();
	
}

void gl_struct1::GLResize(int w, int h)
{
	HGLRC hRC1=wglGetCurrentContext();
	HDC hDC1=wglGetCurrentDC();
	//bool bool1=wglDeleteContext(hRC1);
	//bool bool2=DeleteDC(hDC1);
	StartDC();
	hRC1=wglGetCurrentContext();
	hDC1=wglGetCurrentDC();
	if(w==0)
	w=1;
	if(h==0)
	h=1;
	glViewport(0, 0, w, h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	if (w <= h){
		glOrtho (-nRange, nRange, -nRange*(double)h/w, nRange*(double)h/w, -nRange, nRange);
	}else{
		glOrtho (-nRange*(double)w/h, nRange*(double)w/h, -nRange, nRange, -nRange, nRange);
	}
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	Refresh();
	StopDC();
}

void gl_struct1::GLPaint()
{
	glClear(GL_COLOR_BUFFER_BIT);
	glColor3f(1.0f, 0.0f, 0.0f);
	draw_elements();
}

void gl_struct1::LeftDown(Point p, dword d)
{
	array_ptr->Add("Hi-1!");
	yRot++;
	Refresh();
	//ptr->xRot++;
	//ptr->Refresh();
}

bool gl_struct1::Key(dword d, int p)
{
	bool bool1=1;
	return bool1;
}

void gl_struct1::draw_elements()
{
	glPushMatrix();
	glRotatef(xRot, 1.0f, 0.0f, 0.0f);
	glRotatef(yRot, 0.0f, 1.0f, 0.0f);
	double z,x,y,angle;
	// Call only once for all remaining points
	glBegin(GL_LINE_STRIP);
		z = -50.0f;
		for(angle = 0.0f; angle <= (2.0f*3.1415)*3.0f; angle += 0.1f)
		{
			x = 50.0f*sin(angle);
			y = 50.0f*cos(angle);
			glVertex3f(x, y, z);
			z += 0.5f;
		}
	glEnd();
	glPopMatrix();
}

gl_struct1::gl_struct1()
{
	nRange = 100.0;
	nRange1=10000.0;
	xRot=yRot=0.0;
}
