#include "gl_struct.h"

void gl_struct::GLInit()
{
	glClearColor(1.0f, 1.0f, 1.0f, 1.0f );
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	Refresh();
}

void gl_struct::GLResize(int w, int h)
{
	HGLRC hRC1=wglGetCurrentContext();
	HDC hDC1=wglGetCurrentDC();
	Size sz=GetSize();
	if(sz.cx==0)
	sz.cx=1;
	if(sz.cy==0)
	sz.cy=1;
	glViewport(0, 0, sz.cx, sz.cy);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	if (w <= h){
		glOrtho (-nRange, nRange, -nRange*sz.cy/sz.cx, nRange*sz.cy/sz.cx, -nRange, nRange);
	}else{
		glOrtho (-nRange*sz.cx/sz.cy, nRange*sz.cx/sz.cy, -nRange, nRange, -nRange, nRange);
	}
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	Refresh();
}


void gl_struct::GLPaint()
{
	glClear(GL_COLOR_BUFFER_BIT);
	glColor3f(0.0f, 0.0f, 1.0f);
	draw_elements();
}

void gl_struct::LeftDown(Point p, dword d)
{
	array_ptr->Add("Hi!");
	yRot++;
	Refresh();
}

bool gl_struct::Key(dword d, int p)
{
	bool bool1=1;
	return bool1;
}

void gl_struct::draw_elements()
{
	glPushMatrix();
	glRotatef(xRot, 1.0f, 0.0f, 0.0f);
	glRotatef(yRot, 0.0f, 1.0f, 0.0f);
	double z,x,y,angle;
	// Call only once for all remaining points
	glBegin(GL_LINE_STRIP);
		z = -50.0f;
		for(angle = 0.0f; angle <= (2.0f*3.1415)*3.0f; angle += 0.1f)
		{
			x = 50.0f*sin(angle);
			y = 50.0f*cos(angle);
			glVertex3f(x, y, z);
			z += 0.5f;
		}
	glEnd();
	glPopMatrix();
}



gl_struct::gl_struct()
{
	nRange = 100.0;
	nRange1=10000.0;
	xRot=yRot=0.0;
}



