#include "prueba_OpenGL_DockWindow.h"

prueba_OpenGL_DockWindow::prueba_OpenGL_DockWindow()
{
	CtrlLayout(*this, "Window title");
	Sizeable().MinimizeBox().MaximizeBox();
	//FillArray(arrayctrl1);
	//FillArray(arrayctrl2);
	FillTree(treectrl1);
	FillTree(treectrl2);
	Add(gl1.SizePos());
	AddFrame(menu);
	menu.Set(THISBACK(MainMenu));
	Maximize(true);
	arrayctrl1.AddColumn("Columna uno");
	arrayctrl2.AddColumn("Columna uno");
	gl2.ptr=&gl1;

}

void prueba_OpenGL_DockWindow::DockInit()
{
	DockLeft(Dockable(treectrl1,"Tree1").SizeHint(Size(200,200)).SetGroup("Project Directory"));
	DockLeft(Dockable(treectrl2,"Tree2").SizeHint(Size(200,200)).SetGroup("Project Directory"));
	TabDockGroup(DOCK_LEFT,"Project Directory",0);
	DockRight(Dockable(gl2,"GL-2").SizeHint(Size(200,300)).SetGroup("General Views"));
	DockBottom(Dockable(arrayctrl1,"Array1").SizeHint(Size(200,100)).SetGroup("Auxiliary Frames"));
	DockBottom(Dockable(arrayctrl2,"Array2").SizeHint(Size(200,100)).SetGroup("Auxiliary Frames"));
	TabDockGroup(DOCK_BOTTOM,"Auxiliary Frames",0);
	gl1.array_ptr=&arrayctrl1;
	gl2.array_ptr=&arrayctrl2;
}

void prueba_OpenGL_DockWindow::FillArray(ArrayCtrl &array)
{
	array.AddColumn("Number");
	array.AddColumn("Roman numbers");
	array.MultiSelect();
	for(int i = 0; i < 200; i++)
	array.Add(i, FormatIntRoman(i, true));
}

void prueba_OpenGL_DockWindow::FillTree(TreeCtrl &tree) 
{
	Vector<int> parent, parent2;
	parent.Add(0);
	tree.SetRoot(Image(), "The Tree");
	for(int i = 1; i < 10000; i++) {
		parent.Add(tree.Add(parent[rand() % parent.GetCount()], Image(),
		            FormatIntRoman(i, true)));
		if((rand() & 3) == 0)
			tree.Open(parent.Top());
	}
	tree.Open(0);					
}
void prueba_OpenGL_DockWindow::MainMenu(Bar& bar)
{
	bar.Add("Windows",THISBACK(DockWindowMenu));
}

bool prueba_OpenGL_DockWindow::Key(dword d, int p)
{
	bool bool1=0;
	return bool1;
}


GUI_APP_MAIN
{
	prueba_OpenGL_DockWindow().Run();
}

