#include <Core/Core.h>
#include <SerialPort/SerialPort.h>

using namespace Upp;

// background processing thread
class SerialDataProcessing : public SerialPortNotify<CallbackThread>
{
public:
	SerialDataProcessing()
	{
	}
	
	virtual ~SerialDataProcessing()
	{
	}

	// used as callback executed from within SerialPort.
	// the routine itself is executed in separate thread created by CallbackThread base class
	void OnModbusData(bool isSuccess, Vector<Value> args, void *custom)
	{
		// handler for incoming data from serial port
		// doing something just for example
		// please note this code is executed NOT in the main thread
		if (isSuccess && args.GetCount() == 4)
			Cout() << ">>"
				   << " " << ((int) args[0])
				   << " " << ((int) args[1])
				   << " " << ((int) args[2])
				   << " " << ((int) args[3])
				   << "\n"
			;
	}
	
private:
};

CONSOLE_APP_MAIN
{
	// initialize SerialPort package
	SerialPort::BNFInit(); // uses external file 'proto'
	SerialPort::OpenPorts(); // uses external file 'ports'

	// start background processing thread
	SerialDataProcessing processingThread;
	processingThread.Start();
	
	// if serial port is available, serial != NULL
	SerialPort *serial = SerialPort::GetPort("ser0");
	if (serial)
	{
		String kbd;
		while (kbd != "q")
		{
			if (kbd == "1")
			{
				static const int TIMEOUT = 1000; // timeout [msec]
				
				Vector<Value> sendArgs;
				sendArgs << 1 << 2 << 3 << 4 << 5; //some data to encode into modbus datagram
				
				// SendReceive_ is processed in another (SerialPort) thread,
				// so the routine exits immediately
				serial->SendReceive_<SerialDataProcessing>
				(
					"modbus",  // protocol from 'proto' file to send
					sendArgs,  // arguments to send
					"modbus",  // protocol from 'proto' file to receive
					TIMEOUT,   // timeout used for both send and receive operations
					NULL,      // just a custom pointer routed to callback
					&processingThread, // notification object pointer
					&SerialDataProcessing::OnModbusData // notification routine
				);
			}
			
			kbd = ReadStdIn();
		}
	}

	// shutdown processing thread	
	processingThread.Shutdown();

	// shutdown SerialPort package
	SerialPort::ClosePorts();
	
	// implicit calls of destructors make Wait() for background threads to finish
}
