#include "KeysExample.h"

#define KEYGROUPNAME "Example Keys"
#define KEYNAMESPACE ExampleKeys
#define KEYFILE      <Keys/KeysExample.key>
#include             <CtrlLib/key_source.h>

KeysExample::KeysExample()
{
	AddFrame(menu);
	menu.Set(THISBACK(MakeMenuBar));
	
	CtrlLayoutCancel(*this, "Keys Example");
}

void KeysExample::MakeMenuBar(Bar &bar)
{
	bar.Add("Keys", THISBACK(OnKeysMenu));
}

void KeysExample::OnKeysMenu(Bar &bar)
{
	// The following line will not compile when uncommented
	// bar.Add(ExampleKeys::KEY1().name, THISBACK1(OnKey, 0)).Key(ExampleKeys::KEY1);

	bar.Add(ExampleKeys::COMBINE(AK_, KEY1)().name, THISBACK1(OnKey, 0)).Key(ExampleKeys::COMBINE(AK_, KEY1));
	bar.Add(ExampleKeys::COMBINE(AK_, KEY2)().name, THISBACK1(OnKey, 1)).Key(ExampleKeys::COMBINE(AK_, KEY2));
	bar.Add(ExampleKeys::COMBINE(AK_, KEY3)().name, THISBACK1(OnKey, 2)).Key(ExampleKeys::COMBINE(AK_, KEY3));
	bar.Add(ExampleKeys::COMBINE(AK_, KEY4)().name, THISBACK1(OnKey, 3)).Key(ExampleKeys::COMBINE(AK_, KEY4));
	bar.Add(ExampleKeys::COMBINE(AK_, KEY5)().name, THISBACK1(OnKey, 4)).Key(ExampleKeys::COMBINE(AK_, KEY5));
	bar.Separator();
	bar.Add(ExampleKeys::COMBINE(AK_, EDITKEYS)().name, THISBACK(OnEditKeys)).Key(ExampleKeys::COMBINE(AK_, EDITKEYS));
}

void KeysExample::OnKey(int ix)
{
	PromptOK("You pressed key option " +AsString(ix+1));
}

void KeysExample::OnEditKeys()
{
	EditKeys();
}

GUI_APP_MAIN
{
	KeysExample().Run();
}

