/* This module made by Sergey Nikitin (SV-Soft,Russia)

Algorithm based on wikipedia article 
http://en.wikipedia.org/wiki/Code_128

*/

#include "BarCode128.h"

#include <CtrlLib/CtrlLib.h>
//#include <Core/Core.h>
//#include <Draw/Draw.h>

#define IMAGECLASS BarCode128Img
#define IMAGEFILE <BarCode128/BarCode128.iml>
#include <Draw/iml.h>

BarCode128::BarCode128(){
	stripwidth=1;
	imagehieght=80;
	quietzone=30;
	debugbackground=0;
	showrect=1;
}


Image BarCode128::Code128_To_Image(String s, CodeTable128 ct){
	LOG("=============== NEW CODE GENERATION ============");
	str = s;
	strlen = s.GetLength();
	codeset = ct;
	if (str == "test") return BarCode128Img::BarTest();
	
	is = Size( (11 + 11*strlen + 11 + 13)*stripwidth + quietzone*2 , imagehieght); 
				// 11 modules startbits + 11*n chars + 11 check + 13 stopbits ;
				
	Font fnt = StdFont();
	ts = GetTextSize(str,fnt);
	
	ImageDraw idr(is);
	idrp = &idr;
	
	if (showrect!=0) {
		idr.DrawRect(is,Red());
		idr.DrawRect(1,1,is.cx-2,is.cy-2,White());
	} else {
		idr.DrawRect(0,0,is.cx,is.cy,White());
	}
	
	DrawStrips();
	
	idr.DrawRect((is.cx-ts.cx)/2 ,is.cy-ts.cy-2 ,ts.cx,ts.cy,White());
	idr.DrawText((is.cx-ts.cx)/2 ,is.cy-ts.cy-2 ,str);
	
	return idr;
}

void BarCode128::DrawStrips(){
	nextstrip = quietzone;
	odd = 0;
	//Start BarCode
	ord = STARTWRITE;
	
	DrawStripSym(Encode128(StartCode()));
	
	ord = TEXTWRITE;
	for(int i = 0; i < strlen; i++)
		DrawStripSym(Encode128(CodeShift(str[i])));
	
	ord = CHECKWRITE;
	DrawStripSym(Encode128(CheckCode()));
	
	ord = STOPWRITE;
	DrawStripSym(Encode128(STOP_SYM),13);
}

void BarCode128::DrawStripSym(int sym,int len){
	odd = odd==1?odd=0:odd=1;
	for(int i = 0; i < len; i++) {
		Draw1Strip(sym & (1<<(len-1-i)));
	}
}

void BarCode128::Draw1Strip(int s){
	for(int i = 0; i < stripwidth; i++){
		if (debugbackground==1){
			if (ord == STARTWRITE || ord == STOPWRITE){
				idrp->DrawLine(nextstrip,1,nextstrip,is.cy-2,1,Color(255,180,180));
			}else if (ord == CHECKWRITE){
				idrp->DrawLine(nextstrip,1,nextstrip,is.cy-2,1,Color(180,180,255));
			}else{
				if (odd==1)
					idrp->DrawLine(nextstrip,1,nextstrip,is.cy-2,1,Color(220,255,255));
				else
					idrp->DrawLine(nextstrip,1,nextstrip,is.cy-2,1,Color(255,255,220));
			}
		}

		if (s!=0) {
			idrp->DrawLine(nextstrip,ts.cy/2,nextstrip,is.cy-ts.cy*0.75,1,Black());
		}
		nextstrip++;
	}
}

int BarCode128::StartCode(){
	int sym;
	switch(codeset) {
	case CODE128A:
		sym = START_CODE_A;
		break;
	case CODE128B:
		sym = START_CODE_B;
		break;
	case CODE128C:
		sym = START_CODE_C;
		break;
	default:
		sym = STOP_SYM;
		break;
	}
	return sym;
}


int BarCode128::CodeShift(int sym){
	int ret;
	if (codeset == CODE128B) {
		if (sym >= 32 && sym <=126) {
			ret = sym - 32;
		} else if (sym >= 200 && sym <=211) {
			ret = sym - 105;
		}
		
	}
	return ret;
}


int BarCode128::Encode128(int sym){
	int bar;
	static int code128[] = {
		/* 000 */	0b11011001100 ,
		/* 001 */	0b11001101100 ,
		/* 002 */	0b11001100110 ,
		/* 003 */	0b10010011000 ,
		/* 004 */	0b10010001100 ,
		/* 005 */	0b10001001100 ,
		/* 006 */	0b10011001000 ,
		/* 007 */	0b10011000100 ,
		/* 008 */	0b10001100100 ,
		/* 009 */	0b11001001000 ,
		/* 010 */	0b11001000100 ,
		/* 011 */	0b11000100100 ,
		/* 012 */	0b10110011100 ,
		/* 013 */	0b10011011100 ,
		/* 014 */	0b10011001110 ,
		/* 015 */	0b10111001100 ,
		/* 016 */	0b10011101100 ,
		/* 017 */	0b10011100110 ,
		/* 018 */	0b11001110010 ,
		/* 019 */	0b11001011100 ,
		/* 020 */	0b11001001110 ,
		/* 021 */	0b11011100100 ,
		/* 022 */	0b11001110100 ,
		/* 023 */	0b11101101110 ,
		/* 024 */	0b11101001100 ,
		/* 025 */	0b11100101100 ,
		/* 026 */	0b11100100110 ,
		/* 027 */	0b11101100100 ,
		/* 028 */	0b11100110100 ,
		/* 029 */	0b11100110010 ,
		/* 030 */	0b11011011000 ,
		/* 031 */	0b11011000110 ,
		/* 032 */	0b11000110110 ,
		/* 033 */	0b10100011000 ,
		/* 034 */	0b10001011000 ,
		/* 035 */	0b10001000110 ,
		/* 036 */	0b10110001000 ,
		/* 037 */	0b10001101000 ,
		/* 038 */	0b10001100010 ,
		/* 039 */	0b11010001000 ,
		/* 040 */	0b11000101000 ,
		/* 041 */	0b11000100010 ,
		/* 042 */	0b10110111000 ,
		/* 043 */	0b10110001110 ,
		/* 044 */	0b10001101110 ,
		/* 045 */	0b10111011000 ,
		/* 046 */	0b10111000110 ,
		/* 047 */	0b10001110110 ,
		/* 048 */	0b11101110110 ,
		/* 049 */	0b11010001110 ,
		/* 050 */	0b11000101110 ,
		/* 051 */	0b11011101000 ,
		/* 052 */	0b11011100010 ,
		/* 053 */	0b11011101110 ,
		/* 054 */	0b11101011000 ,
		/* 055 */	0b11101000110 ,
		/* 056 */	0b11100010110 ,
		/* 057 */	0b11101101000 ,
		/* 058 */	0b11101100010 ,
		/* 059 */	0b11100011010 ,
		/* 060 */	0b11101111010 ,
		/* 061 */	0b11001000010 ,
		/* 062 */	0b11110001010 ,
		/* 063 */	0b10100110000 ,
		/* 064 */	0b10100001100 ,
		/* 065 */	0b10010110000 ,
		/* 066 */	0b10010000110 ,
		/* 067 */	0b10000101100 ,
		/* 068 */	0b10000100110 ,
		/* 069 */	0b10110010000 ,
		/* 070 */	0b10110000100 ,
		/* 071 */	0b10011010000 ,
		/* 072 */	0b10011000010 ,
		/* 073 */	0b10000110100 ,
		/* 074 */	0b10000110010 ,
		/* 075 */	0b11000010010 ,
		/* 076 */	0b11001010000 ,
		/* 077 */	0b11110111010 ,
		/* 078 */	0b11000010100 ,
		/* 079 */	0b10001111010 ,
		/* 080 */	0b10100111100 ,
		/* 081 */	0b10010111100 ,
		/* 082 */	0b10010011110 ,
		/* 083 */	0b10111100100 ,
		/* 084 */	0b10011110100 ,
		/* 085 */	0b10011110010 ,
		/* 086 */	0b11110100100 ,
		/* 087 */	0b11110010100 ,
		/* 088 */	0b11110010010 ,
		/* 089 */	0b11011011110 ,
		/* 090 */	0b11011110110 ,
		/* 091 */	0b11110110110 ,
		/* 092 */	0b10101111000 ,
		/* 093 */	0b10100011110 ,
		/* 094 */	0b10001011110 ,
		/* 095 */	0b10111101000 ,
		/* 096 */	0b10111100010 ,
		/* 097 */	0b11110101000 ,
		/* 098 */	0b11110100010 ,
		/* 099 */	0b10111011110 ,
		/* 100 */	0b10111101110 ,
		/* 101 */	0b11101011110 ,
		/* 102 */	0b11110101110 ,
		/* 103 */	0b11010000100 ,
		/* 104 */	0b11010010000 ,
		/* 105 */	0b11010011100 ,
		/* 106 */	0b1100011101011
	};
	bar = code128[sym];
	return bar;
	
}

int BarCode128::CheckCode(){
	int sum = 0;
	int ret;
	sum += START_CODE_B;
	for(int i = 0; i < strlen; i++){
		sum += CodeShift(str[i]) * (i+1) ;
	}
	ret = sum % 103;
	return ret;
	 
}