/* This module made by Sergey Nikitin (SV-Soft,Russia)

Algorithm based on  article on
http://www.barcode.kiev.ua/types_ean.html
http://www.cherry-notes.spb.ru/barcode_ean8.htm

*/

#include "BarEAN.h"

#include <CtrlLib/CtrlLib.h>
//#include <Core/Core.h>
//#include <Draw/Draw.h>

#define IMAGECLASS BarEANImg
#define IMAGEFILE <BarEAN/BarEAN.iml>
#include <Draw/iml.h>

BarEAN13::BarEAN13(){
	stripwidth=1;
	imagehieght=80;
	quietzone=30;
	debugbackground=0;
	showrect=1;
}


Image BarEAN13::EAN_To_Image(String s,int codetype0){
	str = s;
	codetype = codetype0;
	if (codetype!=8 &&codetype!=13) return BarEANImg::BarError();
	
	if (s.GetCharCount()<codetype-1) return BarEANImg::BarTooShort();
	if (s.GetCharCount()>codetype-1) str=s.Mid(0,codetype-1);
	strlen = str.GetLength();
	
	if (str == "test") return BarEANImg::BarTest();
	
	int tlen = 12;
	if (codetype==8) tlen = 8;
	is = Size( (7*(tlen)+3*2+5)*stripwidth + quietzone*2 , imagehieght);
				
	int fontsz = 12;
	if (stripwidth ==1) fontsz = 10;
	if (stripwidth>2) fontsz = 16;
	if (stripwidth>4) fontsz = 24;
	Font fnt = StdFont(fontsz);
	ts = GetTextSize(str,fnt);
	
	ImageDraw idr(is);
	idrp = &idr;
	
	if (strlen==codetype-1){
		if (showrect!=0) {
			idr.DrawRect(is,Red());
			idr.DrawRect(1,1,is.cx-2,is.cy-2,White());
		} else {
			idr.DrawRect(0,0,is.cx,is.cy,White());
		}
		
		DrawStrips();
		
		//idr.DrawRect((is.cx-ts.cx)/2 ,is.cy-ts.cy-2 ,ts.cx,ts.cy,White());
	}else{
		idr.DrawRect(0,0,is.cx,is.cy,White());
		String serr("String legth is not valid");
		ts = GetTextSize(serr,fnt);
		idr.DrawText((is.cx-ts.cx)/2 ,(is.cy-ts.cy)/2 ,serr,fnt);
		String str1 = str;
		char ck = CheckCode()+'0';
		str1.Cat(ck);
		ts = GetTextSize(str1,fnt);
		idr.DrawText((is.cx-ts.cx)/2 ,is.cy-ts.cy-2 ,str1,fnt);
		return idr;
	}
	String str1 = str;
	char ck = CheckCode()+'0';
	str1.Cat(ck);
	
	Size ts0(0,0);
	if (codetype == 13){
		String s0 = str1.Mid(0,1);
		String s1 = str1.Mid(1,6);
		String s2 = str1.Mid(7,6);
		ts0 = GetTextSize(s0,fnt);
		Size ts1 = GetTextSize(s1,fnt);
		Size ts2 = GetTextSize(s2,fnt);
		idr.DrawText(quietzone-ts0.cx-1 ,is.cy-ts.cy-2 ,s0,fnt);
		idr.DrawText(is.cx/2-ts1.cx-stripwidth*2 ,is.cy-ts.cy-2 ,s1,fnt);
		idr.DrawText(is.cx/2+stripwidth*2 ,is.cy-ts.cy-2 ,s2,fnt);
	} else {
		String s1 = str1.Mid(0,4);
		String s2 = str1.Mid(4,4);
		Size ts1 = GetTextSize(s1,fnt);
		Size ts2 = GetTextSize(s2,fnt);
		idr.DrawText(is.cx/2-ts1.cx-stripwidth*2 ,is.cy-ts.cy-2 ,s1,fnt);
		idr.DrawText(is.cx/2+stripwidth*2 ,is.cy-ts.cy-2 ,s2,fnt);
	}
		
	return idr;
}

void BarEAN13::DrawStrips(){
	nextstrip = quietzone;
	odd = 0;
	StartCode();
	//int before
	ord = TEXTWRITE;
	int ind1 = 1;
	int ind2 = 7;
	int ind3 = 12;
	if (codetype == 8){
		LOG("~~1~~");
		ind1 = 0;
		ind2 = 4;
		ind3 = 7;
	}
	
	for( cursymb = ind1; cursymb < ind2; cursymb++){
		
		DrawStripSym(EncodeEAN(str[cursymb]-'0',0));
	}
	MiddleCode();
	ord = TEXTWRITE;
	for( cursymb = ind2; cursymb < ind3; cursymb++){
		DUMP(cursymb);
		DrawStripSym(EncodeEAN(str[cursymb]-'0',3));
	}
	ord = CHECKWRITE;
	DrawStripSym(EncodeEAN(CheckCode(),3));
	StartCode();
	
}

void BarEAN13::DrawStripSym(int sym,int len){
	odd = odd==1?odd=0:odd=1;
	for(int i = 0; i < len; i++) {
		Draw1Strip(sym & (1<<(len-1-i)));
	}
}

void BarEAN13::Draw1Strip(int s){
	for(int i = 0; i < stripwidth; i++){
		int ots = ts.cy+2;
		if (ord == STARTSTOPWRITE) ots = ts.cy/2;
		if (debugbackground==1){
			if (ord == STARTSTOPWRITE){
				idrp->DrawLine(nextstrip,1,nextstrip,is.cy-2,1,Color(255,180,180));
			}else if (ord == CHECKWRITE){
				idrp->DrawLine(nextstrip,1,nextstrip,is.cy-2,1,Color(180,180,255));
			}else{
				if (odd==1)
					idrp->DrawLine(nextstrip,1,nextstrip,is.cy-2,1,Color(220,255,255));
				else
					idrp->DrawLine(nextstrip,1,nextstrip,is.cy-2,1,Color(255,255,220));
			}
		}

		if (s!=0) {
			idrp->DrawLine(nextstrip,ts.cy/2,nextstrip,is.cy-ots,1,Black());
		}
		nextstrip++;
	}
}

void BarEAN13::StartCode(){
	int sym=0b101;
	ord = STARTSTOPWRITE;
	DrawStripSym(sym,3);
	
}
void BarEAN13::MiddleCode(){
	int sym=0b01010;
	ord = STARTSTOPWRITE;
	DrawStripSym(sym,5);
	
}


int BarEAN13::EncodeEAN(int sym,int tbl){
	int bar;
	static int EAN_A[] = {
		/* 000 */	0b0001101 ,
		/* 001 */	0b0011001 ,
		/* 002 */	0b0010011 ,
		/* 003 */	0b0111101 ,
		/* 004 */	0b0100011 ,
		/* 005 */	0b0110001 ,
		/* 006 */	0b0101111 ,
		/* 007 */	0b0111011 ,
		/* 008 */	0b0110111 ,
		/* 009 */	0b0001011 ,
	};

	static int EAN_B[] = {
		/* 000 */	0b0100111 ,
		/* 001 */	0b0110011 ,
		/* 002 */	0b0011011 ,
		/* 003 */	0b0100001 ,
		/* 004 */	0b0011101 ,
		/* 005 */	0b0111001 ,
		/* 006 */	0b0000101 ,
		/* 007 */	0b0010001 ,
		/* 008 */	0b0001001 ,
		/* 009 */	0b0010111 ,
	};

	static int EAN_C[] = {
		/* 000 */	0b1110010 ,
		/* 001 */	0b1100110 ,
		/* 002 */	0b1101100 ,
		/* 003 */	0b1000010 ,
		/* 004 */	0b1011100 ,
		/* 005 */	0b1001110 ,
		/* 006 */	0b1010000 ,
		/* 007 */	0b1000100 ,
		/* 008 */	0b1001000 ,
		/* 009 */	0b1110100 ,
	};

	static int EAN_TBL[] = {
		/* 000 */	0b000000 ,
		/* 001 */	0b001011 , 
		/* 002 */	0b001101 ,
		/* 003 */	0b001110 ,
		/* 004 */	0b010011 ,
		/* 005 */	0b011001 ,
		/* 006 */	0b011100 ,
		/* 007 */	0b010101 ,
		/* 008 */	0b010110 ,
		/* 009 */	0b011010 ,
	};

	if (tbl == 0){
		if (codetype == 8){
			tbl = 1;
		} else {
			int firstletter = str[0] - '0';
			int tpl = EAN_TBL[firstletter];
			tbl = ((tpl >> (6 - cursymb))&1)+1;
		}
	}
	if (sym >=0 && sym <= 9) {
		if (tbl == 1) bar = EAN_A[sym];
		else if (tbl == 2) bar = EAN_B[sym];
		else if (tbl == 3) bar = EAN_C[sym];
		else  bar = 0b1111111;
	} else {
		bar = 0b1111111;
	}

	
	return bar;
}

int BarEAN13::CheckCode(){
	LOG("==============================CheckCode=====================");
	int odd_sum = 0;
	int even_sum = 0;
	int sum = 0;
	for(int i = 0; i < strlen; i++)
	{
		int dig = str[i] - '0';
		if (i%2==0){
			odd_sum+= dig;
		}else{
			even_sum+=dig;
		}
	}
	DUMP(odd_sum);
	DUMP(even_sum);
	if (codetype==8){
		sum = 10-(even_sum+odd_sum*3)%10;
		DUMP(even_sum+odd_sum*3);
		DUMP(sum);
	} else {
		sum = 10-(even_sum*3+odd_sum)%10;
		DUMP(even_sum*3+odd_sum);
		DUMP(sum);
	}
	return sum;
	 
}