#ifndef _BarEAN_BarEAN_h
#define _BarEAN_BarEAN_h


#include <Core/Core.h>
#include <Draw/Draw.h>



using namespace Upp;




class BarEAN13  {
	typedef BarEAN13 CLASSNAME;
	public:
		typedef enum {STARTSTOPWRITE,TEXTWRITE,CHECKWRITE,} WriteOrder;
	
		BarEAN13();
	protected:
		ImageDraw *idrp;
		String str;
		int strlen;
		int cursymb;
		int codetype;
		Size is;
		Size ts;
		void DrawStrips();
		void DrawStripSym(int sym,int len=7);
		void Draw1Strip(int s);
		int nextstrip;
		int stripwidth;
		int imagehieght;
		int quietzone;
		int showrect;
		int debugbackground;
		int odd;
		WriteOrder ord;
		
		void StartCode();
		void MiddleCode();
		int EncodeEAN(int sym,int tbl);
		int CodeShift(int sym);
		int CheckCode();
	
	public:
		Image EAN_To_Image(String s1,int codetype=13);
		
		void StripWidth(int sw=2)		{stripwidth=sw;}
		void ImageHieght(int ih=80)		{imagehieght=ih;}
		void QuietZone(int qz=30)		{quietzone=qz;}
		void DebugBackground(int db=0)	{debugbackground=db;}
		void ShowRect(int sr=1)			{showrect=sr;};
	
};



#endif
