#include "BarCode_test.h"

#define IMAGECLASS BarCode_testImg
#define IMAGEFILE <BarCode_test/BarCode_test.iml>
#include <Draw/iml_source.h>


#include <BarCode128/BarCode128.h>
#include <BarEAN/BarEAN.h>
BarCode_test::BarCode_test()
{
	CtrlLayoutOK(*this, "BarCode128_test");
	Sizeable().Zoomable();
	str << THISBACK(ImageRecalc);
	im.SetImage(BarCode128().Code128_To_Image("test",CODE128B));
	Icon(BarCode_testImg::barcode128());
	stripwidth<<=2;
	imagehieght<<=80;
	quietzone<<=30;
	debugbackground<<=0;
	str <<= "1234";
	savepng << THISBACK(ImageSavePng);
	symb <<= 2;

	rectbarcode << THISBACK(ImageRecalc);
	stripwidth<<THISBACK(ImageRecalc);
	imagehieght<<THISBACK(ImageRecalc);
	quietzone<<THISBACK(ImageRecalc);
	debugbackground<<THISBACK(ImageRecalc);
	symb<<THISBACK(ImageRecalc);
	symb.Add(1,"Code128");
	symb.Add(2,"EAN13");
	symb.Add(3,"EAN8");
}

void BarCode_test::ImageSavePng(){
	PNGEncoder png;
	FileSel fs;
	fs.MkDirOption();
	fs.DefaultExt("png");
	fs.Type("PNG image","png");
	fs.AllFilesType();
	if(!fs.ExecuteSaveAs(t_("Enter File Name to save PNG Image")))
		return;
	png.SaveFile(~fs, image);

}

void BarCode_test::ImageRecalc() {
	if (~symb == 1){
		Single<BarCode128>().StripWidth(~stripwidth);
		Single<BarCode128>().ImageHieght((int(~imagehieght)<20)? 20:int(~imagehieght));
		Single<BarCode128>().QuietZone(~quietzone);
		Single<BarCode128>().DebugBackground(~debugbackground);
		Single<BarCode128>().ShowRect(~rectbarcode);
		image = Single<BarCode128>().Code128_To_Image(~str,CODE128B);
	} else if (~symb == 2 || ~symb == 3) {
		Single<BarEAN13>().StripWidth(~stripwidth);
		Single<BarEAN13>().ImageHieght((int(~imagehieght)<20)? 20:int(~imagehieght));
		Single<BarEAN13>().QuietZone(~quietzone);
		Single<BarEAN13>().DebugBackground(~debugbackground);
		Single<BarEAN13>().ShowRect(~rectbarcode);
		int type=13;
		if (~symb == 3) type=8;
		image = Single<BarEAN13>().EAN_To_Image(~str,type);
	}
	
	im.SetImage(image);
	im.Refresh();
	im.Sync();
}

GUI_APP_MAIN
{
	BarCode_test().Run();
}
