#include <CtrlLib/CtrlLib.h>

using namespace Upp;
#define IMAGECLASS Img
#define IMAGEFILE <ButtonsInArray/no_style.iml>
#include <Draw/iml_header.h>
#define IMAGECLASS Img
#define IMAGEFILE <ButtonsInArray/no_style.iml>
#include <Draw/iml_source.h>
 
One<Button::Style> no_style;
INITBLOCK {
	no_style.Create();
	*no_style = Button::StyleNormal();
	for (int i=0; i<4; i++)
		no_style->look[i] = Null;
	no_style->pressoffset = Point(2,2);
};

void MakePlus(One<Ctrl>& ctrl)
{
	ctrl.Create<Button>();
	Button* b = (Button*) ~ctrl;
	b->WantFocus(false);
	b->SetStyle(*no_style);
	b->SetImage(Img::plus());
}

void MakeMinus(One<Ctrl>& ctrl)
{
	ctrl.Create<Button>();
	Button* b = (Button*) ~ctrl;
	b->WantFocus(false);
	b->SetStyle(*no_style);
	b->SetImage(Img::minus());
}

struct ButtonsInArray : TopWindow {
	ArrayCtrl list;
	typedef ButtonsInArray CLASSNAME;
	ButtonsInArray()
	{
		Sizeable().MinimizeBox().MaximizeBox();
		Add(list.SizePos());
		list.SetLineCy(70);
		list.AddColumn("#").HeaderTab().Fixed(50);
		list.AddColumn("Description");
		list.AddColumn("+").HeaderTab().Fixed(70);
		list.AddColumn("-").HeaderTab().Fixed(70);
		list.ColumnAt(2).Ctrls(MakePlus);
		list.ColumnAt(3).Ctrls(MakeMinus);
		
		list.Add(0, "Pizza Margharita");
		list.Add(0, "Pizza Doner");
		list.Add(0, "Pizza Quattro Stagioni");
		list.Add(0, "Pizza Proscuito");
		
		for (int i=0; i<list.GetCount(); i++)
		{
			Button* p = (Button*)list.GetCtrl(i, 2), *m = (Button*)list.GetCtrl(i, 3);
			if (p) *p <<=THISBACK1(DoPlus, i);
			if (m) *m <<=THISBACK1(DoMinus, i);
		}
	}
	void DoPlus(int i)
	{
		list.Set(i, 0, (int)list.Get(i, 0)+1);
	}
	void DoMinus(int i)
	{
		int n = list.Get(i, 0);
		if (n>0)
			list.Set(i, 0, n-1);
	}
};

GUI_APP_MAIN
{
	Draw::SetStdFont(StdFont(16)());
	ButtonsInArray().Run();
}
