#ifndef _SWPR_OEEDATA_h_
#define _SWPR_OEEDATA_h_
#include <CtrlLib/CtrlLib.h>
#include <SqlCtrl/SqlCtrl.h>

#include <plugin/sqlite3/Sqlite3.h>

using namespace Upp;

#define SCHEMADIALECT <plugin/sqlite3/Sqlite3Schema.h>

//Defining triple primary key
#define TRIPLE_PRIMARY_KEY(k1, k2, k3)   INLINE_ATTRIBUTE(", primary key (" #k1 ", " #k2 ", " #k3 ")")
#define MODEL <SWPR/OEE_db.sch>
#include "Sql/sch_header.h"
#define LAYOUTFILE <SWPR/OEE.lay>

//#include <Sql/sch_header.h>
#include <Sql/sch_source.h>
#include <Sql/sch_schema.h>

#include <CtrlCore/lay.h>


//=== Estendo il template T con l'evento LostFocus ===
template <class T>
struct WithFocusCallbacks : public T {
	Callback WhenGotFocus, WhenLostFocus;

	virtual void GotFocus() {
		T::GotFocus();
		WhenGotFocus();
	}

	virtual void LostFocus() {
		T::LostFocus();
		WhenLostFocus();
	}
};
//====================================================

// pezDlg will be visible in all files that #include Layouts.h
struct pezDlg : WithpezDlg<TopWindow> { // ParentCtrl is a good base class for tabs
	
	WithFocusCallbacks<EditString> strCommPezz;
	
	typedef pezDlg CLASSNAME;
	pezDlg();
};

#endif
