#include "OEEDATA.h"

using namespace Upp;

struct Interface : TopWindow {
	Button btnNewCollection;
	pezDlg dlgSelectDrums;

	void ChangeDrum();
	void ListDrums(WString MyOrder, WString MyPhase);
	int CountDrumsProduced(WString MyOrder, WString MyPhase);
	void CountDrumsRequested();
	int SplitOrderid();
	void dlgSelectJoborder();
	void btnFindPressed();
	void CleanFieldsdlgPezz();

	typedef Interface CLASSNAME;
	
	Interface()
	{
		Title(t_("Data collection")).Sizeable();
		*this << btnNewCollection.SetLabel(t_("Select job order")).LeftPos(80,120).TopPos(600,30);
		btnNewCollection << THISBACK(dlgSelectJoborder);
	}
};

GUI_APP_MAIN
{
	Interface app;

	//Connect to the db
	Sqlite3Session sqlite3;
	sqlite3.LogErrors(true);
	if(!sqlite3.Open(ConfigFile("swpr.db"))) {
		LOG("Can't create or open database file\n");
		return;
	}
	SQL = sqlite3;

	app.Sizeable().Zoomable();
	app.Maximize();
	
	app.Run();
}

void Interface::ChangeDrum() {
		dlgSelectDrums.strLav3D = dlgSelectDrums.lengthList.GetLabel();
	}

void Interface::ListDrums(WString MyOrder, WString MyPhase)
{
	SQL.ClearError();
	try {
		Sql query;
		query * Select(DRUM, N_DRUM, METER)
		        .From(DRUMLIST)
		        .Where(ORDERID == AsString(MyOrder));
		int i = 0;
		int k = 0;
		int drumtypedone = 0;
		while (query.Fetch())
		{
			int n_of_drums = (int)(query[N_DRUM]);
			drumtypedone = SQL % Select(SqlCountRows())
							.From(JOBS)
							.Where( ORDERID == AsString(MyOrder) && PHASE == AsString(MyPhase) && DRUMTYPE ==AsString(query[DRUM]) );
			for(int j = 0; j < n_of_drums; j++)
			{
				dlgSelectDrums.lengthList.Set(i, AsString(query[DRUM]), ( AsString(query[METER]) + "m - N: " + AsString(k+1) + " of " + AsString(n_of_drums)));
				if (k<drumtypedone) { dlgSelectDrums.lengthList.DisableCase(i); }
				i++;
				k++;
			}
			drumtypedone = 0;
			k = 0;
		}
		dlgSelectDrums.lengthList.Set(i, "777", t_(" unknown length"));
		dlgSelectDrums.lengthList = "777";
	} catch(SqlExc &err) {
		Cerr() << "ERROR: " << err << "\n";
		ErrorOK(t_("Unable to receive data from the db: ") + SQL.GetLastError());
		SetExitCode(1);
	}
}

int Interface::CountDrumsProduced(WString MyOrder, WString MyPhase)
{
	int ritorno = 0 ;
	SQL.ClearError();
	try {
		ritorno = SQL % Select(SqlCountRows())
			.From(JOBS)
			.Where( ORDERID == AsString(MyOrder) && PHASE == AsString(MyPhase));
	} catch(SqlExc) {
		ErrorOK(t_("Unable to receive data from the db: ") + SQL.GetLastError());
		SetExitCode(1);
	}
	return ritorno;
}

void Interface::CountDrumsRequested()
{
	SQL.ClearError();
	try {
		int ritorno = Select(SqlSum(N_DRUM))
		.From(DRUMLIST)
		.Where( ORDERID == ~dlgSelectDrums.strLav3A );

	} catch(SqlExc &err) {
		Cerr() << "ERROR: " << err << "\n";
		ErrorOK(t_("Unable to receive data from the db: ") + SQL.GetLastError());
		SetExitCode(1);
	}
}

int Interface::SplitOrderid()
{
	int ritorno = 1;
	std::string ingresso = (String)~dlgSelectDrums.strCommPezz;
    WString pulita = (WString)TrimBoth(ingresso);
	pulita = pulita.Left(pulita.GetLength() - 1);
	WString comm = pulita.Left(pulita.GetLength() - 2);
	WString fas = pulita.Right(2);
	dlgSelectDrums.strLav3A = comm;
	dlgSelectDrums.strLav3B = fas;
	dlgSelectDrums.strLav3C = CountDrumsProduced(comm, fas) + 1;
	if (fas == (WString)"90")
	{
		ListDrums(comm, fas);
	}
	return ritorno;
}

pezDlg::pezDlg() // Constructor needs to be in .cpp
{
	CtrlLayoutOKCancel(*this, t_("Select job and drum")); // Places widgets into positions
	Add(strCommPezz.LeftPosZ(16, 148).TopPosZ(12, 19));
}


void Interface::dlgSelectJoborder()
{
	CtrlLayoutOKCancel(dlgSelectDrums, t_("Select job and drum"));
	dlgSelectDrums.btnFind <<= THISBACK(btnFindPressed);
	dlgSelectDrums.strLav3D <<= THISBACK(ChangeDrum);
	dlgSelectDrums.strCommPezz.Enable();
	dlgSelectDrums.ok.Disable();
	dlgSelectDrums.btnFind.Ok();
	switch(dlgSelectDrums.Execute())
	{
		case IDOK:
			return;
		case IDCANCEL:
			dlgSelectDrums.ok.Disable();
			dlgSelectDrums.btnFind.Ok().Enable();
			CleanFieldsdlgPezz();
			return;
		default:
			break;
	}
}

void Interface::btnFindPressed()
{
	if (SplitOrderid() > 0)
	{
		dlgSelectDrums.ok.Enable();
		dlgSelectDrums.ok.Ok();
		dlgSelectDrums.btnFind.Normal().Disable();
	} else {
		PromptOK(t_("ATTENZIONE: commessa non trovata, effettuare di nuovo lo scan"));
		CleanFieldsdlgPezz();
	}
}

void Interface::CleanFieldsdlgPezz()
{
	dlgSelectDrums.strLav3A <<= Null;
	dlgSelectDrums.strLav3B <<= Null;
	dlgSelectDrums.strLav3C <<= Null;
	dlgSelectDrums.strLav3D <<= Null;
	dlgSelectDrums.strLav3Dbis <<= Null;
	dlgSelectDrums.strMacchina <<= Null;
	dlgSelectDrums.strCommPezz <<= Null;
	dlgSelectDrums.lengthList.Reset();
	dlgSelectDrums.strCommPezz.SetFocus();
}
