
#include "TreeGridDemo.h"

#include <ctime>
#include <cstdlib>
#include <cstdarg>
#include <algorithm>
#include <vector>


#define IMAGEFILE <TreeGridDemo/TreeGridDemo.iml>
#define IMAGECLASS TGWTPics
#include <Draw/iml.h>



//-------------------------------------------------------------------------------(simple Displays for testing)
struct TestColumnDisplay : public Display
{
	void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const
	{
		std::string s=(const char*)q.ToString();
		std::transform(s.begin(), s.end(), s.begin(), [](char a){return((((a>='a')&&(a<='z'))?(a-32):a));}); //u-case
		w.DrawRect(r, paper);
		w.DrawText(r.left, r.top + (r.Height() - StdFont().Info().GetHeight()) / 2,
		           s.c_str(),
		           StdFont(),
		           ink);
	}
};

struct TestCellDisplay : public Display
{
	void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const
	{
		std::string s=(const char*)q.ToString();
		w.DrawRect(r, paper);
		w.DrawText(r.left, r.top + (r.Height() - StdFont().Info().GetHeight()) / 2,
		           s.c_str(),
		           StdFont().Bold().Italic(),
		           Red());
	}
};


//-------------------------------------------------------------------------------(tree-grid tester)
TreeGridDemo::TreeGridDemo()
{
	CtrlLayout(*this, "TreeGridDemo");
	SetRect(Size(1000, 800));
	Sizeable();
	
	//Add(DemoLbl.HSizePosZ().TopPos(0,16));
	DemoLbl.SetLabel("Press 'F1' for Help").SetFont(StdFont().Bold()).SetInk(Red());
	
	//Add(TG.HSizePosZ().VSizePosZ(16));

	InitTG();
	FillTG();
	TG.RefreshTreeGrid();
}

TreeGridDemo::~TreeGridDemo()
{
	TG.Clear();
}

void TreeGridDemo::InitTG()
{
	TG.WhenActivate = THISBACK(OnActivate);
	TG.WhenBeforeNodeExpand = THISBACK(OnBeforeExpand);
	TG.WhenAfterNodeContract = THISBACK(OnAfterContract);
	TG.WhenMenuBar = THISBACK(OnMenuBar);

	TG.ListExpandingNodes(EXD_LAST);
	
	TG.AddColumn("This is the Tree column (idx==0)", 300).Sorting();
	TG.AddColumn("First column (idx==1)", 200).SetDisplay(Single<TestColumnDisplay>());
	TG.AddColumn("Numbers column (idx==2)", 250).Sorting(THISBACK(SortNumCol)).Align(ALIGN_RIGHT);
	TG.AddColumn("yac (idx==3)", 250).Sorting().Align(ALIGN_CENTER);
}


void TreeGridDemo::FillTG(Node N)
{
	//String a,b,c,d;
	Value a,b,c,d;
	Image pic;
	Node X;
	UTIL U;
	//int n;

	for (int i=0;i<5;i++)
	{
		a=U.fake_word().c_str();
		b=U.fake_word().c_str();
		//c.Clear();
		c=U.getrandom(1,100);
		d=U.fake_word().c_str();
		switch (i%4)
		{
			case 0: pic=TGWTPics::nodepic1(); break;
			case 1: pic=TGWTPics::nodepic2(); break;
			case 2: pic=TGWTPics::nodepic3(); break;
			default:  pic.Clear();
		}
		
//	String S;
//	S << "pic: " << ((pic.IsEmpty())?"empty":"ok") << "&";
//	S << "a: " << a.GetTypeName() << " = " << a.ToString() << "&";
//	S << "b: " << b.GetTypeName() << " = " << b.ToString() << "&";
//	S << "c: " << c.GetTypeName() << " = " << c.ToString() << "&";
//	S << "d: " << d.GetTypeName() << " = " << d.ToString() << "&";
//	PromptOK(S);
		
		if (!pic.IsEmpty())
			X=TG.AddNode(N, pic, a.ToString(), "", b, c, d);
		else
			X=TG.AddNode(N, a.ToString(), "", b, c);
		if ((i%3)==1)
			TG.AddNode(X, "*"); //show expand-"button"
	}
}

bool TreeGridDemo::SortNumCol(const Node &l, const Node &r)
{
	if ((l->CellCount()<3)||(r->CellCount()<3)) return false;
	EXDisp exd=TG.ListExpandingNodes();
	if (exd!=EXD_NONE)
	{
		if (!l->IsEmpty()&&r->IsEmpty()) return (exd==EXD_FIRST)?true:false;
		if (l->IsEmpty()&&!r->IsEmpty()) return (exd==EXD_FIRST)?false:true;
	}
	Value vl=l->CellAt(2)->GetData(), vr=r->CellAt(2)->GetData();
	bool blN=IsNull(vl), brN=IsNull(vr);
	if (blN || brN) return !blN ? true : !brN ? false : false;
	if (!IsNumber(vl)||!IsNumber(vr)) return false;
	int nl=vl, nr=vr;
	if (TG.IsSortASC()) return (nl<nr); else return (nl>nr);
	return false;
}

void TreeGridDemo::OnActivate(Node N, size_t cellidx)
{
	N->CellAt(cellidx)->SetDisplay(Single<TestCellDisplay>());
}

void TreeGridDemo::OnBeforeExpand(Node N)
{
	//this is BEFORE expansion - for adding/removing content..
	
	if (N->IsEmpty()||(N->NodeAt(0)->CellAt(0)->GetData().ToString().Compare("*")!=0)) return;
	TG.ClearNodes(N); //remove "*"
	FillTG(N);
}

void TreeGridDemo::OnAfterContract(Node N)
{
	//this is AFTER contracting - for adding/removing content..

	if (!N->IsEmpty()) //only if it has sub-nodes
	{
		TG.ClearNodes(N);
		TG.AddNode(N, "*"); /// to show expand-arrow
	}
}

void TreeGridDemo::OnMenuBar(MenuBar &bar)
{
	//e.g:
	//std::vector<Node> vSel;
	//TG.GetSelection(vSel); //vSel is sorted ascending based on row-position in grid
	
	Node N=TG.GetFocusNode();
	
	bar.Add((N), "Rename current cell", THISBACK1(OnRenameCell,N));
	bar.Separator();
	bar.Add("Show Expandable nodes first", Callback(lambda([&]{ TG.ListExpandingNodes(EXD_FIRST); })));
	bar.Add("Show Expandable nodes last", Callback(lambda([&]{ TG.ListExpandingNodes(EXD_LAST); })));
	bar.Add("Show Expandable nodes unordered", Callback(lambda([&]{ TG.ListExpandingNodes(EXD_NONE); })));
	bar.Separator();
	bar.Add((TG.ShowHeader())?"Hide Header":"Show Header", Callback(lambda([&]{ TG.ShowHeader(!TG.ShowHeader()); })));
	bar.Separator();
	bar.Add((TG.ShowTreeLines())?"Hide Treelines":"Show Treelines", Callback(lambda([&]{ TG.ShowTreeLines(!TG.ShowTreeLines()); })));

}

void TreeGridDemo::OnRenameCell(Node N)
{
	UTIL U;
	std::string snew="new name: "; //get it from somewhere
	snew+=U.fake_word();
	size_t idx=TG.GetFocusCell();
	N->CellAt(idx)->SetData(Value(snew.c_str()));
	TG.RefreshTreeGrid();
}

