#ifndef _TreeGridDemo_TreeGridDemo_h
#define _TreeGridDemo_TreeGridDemo_h

#include <CtrlLib/CtrlLib.h>

#include <TreeGrid/treegrid.h>

using namespace Upp;

#define LAYOUTFILE <TreeGridDemo/tgd.lay>
#include <CtrlCore/lay.h>

struct TreeGridDemo : public WithtgdLayout<TopWindow>
{
	typedef TreeGridDemo CLASSNAME;
	
	//Label DemoLbl;
	//TreeGrid TG;

	TreeGridDemo();
	virtual ~TreeGridDemo();
	
	void InitTG();
	void FillTG(Node N=nullptr);
	
	void OnActivate(Node N, size_t cellidx);
	void OnBeforeExpand(Node N);
	void OnAfterContract(Node N);
	void OnMenuBar(MenuBar &menubar);
	void OnRenameCell(Node N);
	
	bool SortNumCol(const Node &l, const Node &r);
};


struct UTIL
{
	//-------------------------------------------------------------------------------(some utility functions)
	int getrandom(int nmin, int nmax)
	{
		int limit = (nmax-nmin);
		int divisor = RAND_MAX/(limit+1);
		int retval;
		
		do { retval = Random() / divisor; } while (retval > limit);
		return (int)(retval+nmin);
	}
	
	const std::string fake_word()
	{
		std::string s(""), v="AEIOUaeiou";
		int len=getrandom(1, 15);
		char c;
		//commented-out to speed things up...
		//auto is_vowel = [&v](char c){ return (v.find(c)!=std::string::npos); };
		auto is_alpha = [](char c){ return (((c>='A')&&(c<='Z'))||((c>='a')&&(c<='z'))); };
		//auto is_cons = [is_vowel, is_alpha](char c){ return (is_alpha(c)&&!is_vowel(c)); };
		while (s.size()<len)
		{
			c=getrandom(32, 126);
			if (is_alpha(c))
			{
				s+=c;
				//if (is_vowel(c)) { while (!is_cons(c)) c=getrandom(32, 126); }
				//else { while (!is_vowel(c)) c=getrandom(32, 126); }
				//s+=c;
			}
		}
		std::transform(s.begin(), s.end(), s.begin(), [](char a){return((((a>='A')&&(a<='Z'))?(a+32):a));}); //l-case
		return s;
	}
	
	void Uout(const std::string &fmt, ...)
	{
	    size_t n, len=100;
		std::string s;
	    bool b=false;
	    va_list marker;
	    while (!b)
	    {
	        s.resize(len);
	        va_start(marker, fmt);
	        n = vsnprintf((char*)s.c_str(), len, fmt.c_str(), marker);
	        va_end(marker);
	        if ((n>0) && ((b=(n<len))==true)) s.resize(n); else len*=2;
	    }
		PromptOK(DeQtf(s.c_str()));
	}
	
};



#endif
