#ifndef _sfm_content_h_
#define _sfm_content_h_

#include <CtrlLib/CtrlLib.h>
using namespace Upp;


#define LAYOUTFILE <sfm/sfm.lay>
#include <CtrlCore/lay.h>


#include <TreeGrid/treegrid.h>
#include "controlpanel.h"

#include <map>


//-----------------------------------------------------------------------------
struct DirContent;

//-----------------------------------------------------------------------------
struct DlgGetRunFile : public WithgetrunfileLayout<TopWindow>
{
	typedef DlgGetRunFile CLASSNAME;

	bool b;
	std::map<std::string, std::string> mex;
	DlgGetRunFile();
	virtual ~DlgGetRunFile() {}
	void ok() { std::string s=e.GetData().ToString().ToStd(); b=true; Close(); }
	void quit() { b=false; Close(); }
	bool Key(dword key, int count) { if (key==K_ENTER) ok(); else if (key==K_ESCAPE) quit(); }
	void browse();
	void setmex(std::map<std::string, std::string> m);
};


//-----------------------------------------------------------------------------
struct PropsDlg : public WithpropsLayout<TopWindow>
{
	typedef PropsDlg CLASSNAME;
	
	Node N;
	std::string sDE;
	bool bdirty;
	
	PropsDlg();
	PropsDlg(Node P);
	virtual ~PropsDlg();
	void ShowInfo();
	void OnClose();
	void OnChange();
	void OnReset();
	void OnApply();
};


//-----------------------------------------------------------------------------
struct RootWarnLabel : public Label
{
	typedef RootWarnLabel CLASSNAME;
	virtual ~RootWarnLabel() {}
	void Paint(Draw &drw)
	{
		Size tsz, sz=GetSize();
		int x, y;
		String S="Careful: \"I am (G)root\"";
		drw.DrawRect(sz, LtRed());
		tsz=GetTextSize(S, StdFont().Bold());
		x=(sz.cx-tsz.cx)/2;
		y=(sz.cy-tsz.cy)/2;
		drw.DrawText(x, y, S, StdFont().Bold(), White());
	}
};


//-----------------------------------------------------------------------------
struct FindDlg : public WithfindLayout<TopWindow>
{
	DirContent *pDC;
	typedef FindDlg CLASSNAME;
	FindDlg();
	void set_pdc(DirContent *pdc) { pDC=pdc; }
	void OnBar(Bar &bar);
	void OpenInTab();
	void OnBrowse();
	void OnClose();
	void OnFind();
	void ShowFiles(const std::vector<std::string> &vFound);
};


//=============================================================================
struct DirContent : public Ctrl
{
	typedef DirContent CLASSNAME;

	std::string sRNDir;
	enum { DO_DISCARD=0, DO_DIR, DO_FILE, };
	FindDlg dlgfind;
	ControlPanel Pan;
	RootWarnLabel IAmROOT;
	TreeGrid TG;
	
	struct //entry_info
	{
		Image pic;
		std::string sName, sSize, sType, sRights, sOwner, sDate;
		void clear() { pic.Clear(); sName.clear(); sSize.clear(); sType.clear();
						sRights.clear(); sOwner.clear(); sDate.clear(); }
	} EI;

	Callback4<const std::string&, const std::string&, bool, const std::string&> WhenOpenTab;
	Gate2<std::string, bool> CheckIsTabOpen;
	
	const std::string to_kmgt(long long n); //Kilo Mega Giga Terra ...
	
	void get_root_stats(std::string &sDir);
	int get_stats(struct dirent *pd, const std::string &sDE);

	void load_dir_entries(Node N, std::string sDir);
	void reload_focus(Node N, const std::string sKey="");
	void sort_entries(Nodes &nodes);
	bool cb_has_files();
	bool sort_size_col(const Node &l, const Node &r);
	bool create_dot_sfm();
	bool do_delete_node(Node N);
	void do_backup(const std::string sS);
	
	DirContent();
	DirContent(const DirContent &dc) {}
	
	virtual ~DirContent();
	
	DirContent& operator=(const DirContent &dc) { sRNDir=dc.sRNDir; return *this; }

	bool Key(dword key, int);
	virtual bool HotKey(dword key);
	
	void Load(); //NB: called from tabxctrl::AddTab() to fill tree

	const std::string GetDCDir();
	void SetLock(const std::string &key, bool bLock=true);
	void FocusNodeKey(const std::string &key);
	void ExpandFocusKey(const std::string &key);
	
	void OnPanelFind(PicButton *pb);
	void OnPanelHome(PicButton *pb);
	void OnPanelRefresh(PicButton *pb);
	void OnPanelNodeTBN(PicButton *pb);
	
	void OnFocus(Node N);
	void OnBExpand(Node N);
	void OnAContract(Node N);
	void OnActivate(Node N, size_t cellidx);
	void OnSorting(size_t idx, size_t ns);
	
	void OnMenuBar(MenuBar &bar);
	
	void OnMenuOpen(Node N);
	void OnOpenWith(Node N);
	void OnMenuRun(Node N);
	void OnMenuNewDir(Node N);
	void OnMenuNewTextFile(Node N);
	void OnMenuRename(Node N);
	void OnMenuCopy();
	void OnMenuPaste(Node N);
	void OnMenuMove(Node N);
	void OnMenuDelete();
	void OnMenuErase();
	void OnMenuHelp();
	void OnMenuProperties(Node N);
	void OnCustomize(Bar &bar);


};





#endif
