
#include "dircontent.h"
#include "linuxsys.h"
#include "util.h"

#include <string>
#include <vector>
#include <sys/stat.h>

FindDlg::FindDlg()
{
	CtrlLayout(*this, "Find");
	SetRect(0, 0, 900, 700);
	Sizeable();

	pDC=nullptr;

	ebDir.SetData("/");
	optSubs.Set(true);
	radFG <<= 0;
	ebFind.SetData("");
	optCase.Set(false);
		
	arFind.AddColumn("Found", 300).Sorting();
	arFind.AddColumn("Size", 80).Sorting();
	arFind.AddColumn("Type", 80).Sorting();
	arFind.AddColumn("Rights", 100);
	arFind.AddColumn("Owner", 80).Sorting();
	arFind.AddColumn("Date", 150).Sorting(); //string-sort is fine
	arFind.WhenBar << THISBACK(OnBar);

	btnBrowse.WhenPush << THISBACK(OnBrowse);
	btnClose.WhenPush << THISBACK(OnClose);
	btnFind.WhenPush << THISBACK(OnFind);
}

void FindDlg::OnBar(Bar &bar)
{
	if (pDC&&(arFind.GetCursor()>=0)) bar.Add("Open in Tab", THISBACK(OpenInTab));
}

void FindDlg::OpenInTab()
{
	int cr;
	std::string s, sn, sk;
	if ((cr=arFind.GetCursor())>=0)
	{
		s=arFind.Get(cr, 0).ToString().ToStd();
		sk=getdepath(s);
		sn=getdename(sk);
		spf(s, "N%s", s.c_str());
		pDC->SetFocus();
		pDC->WhenOpenTab(sn, sk, true, s);
	}
}

void FindDlg::OnBrowse()
{
	std::string s=SelectDirectory().ToStd();
	if (isextant(s, DE_DIR)) ebDir.SetData(s.c_str());
}

void FindDlg::OnClose() { Close(); }

void FindDlg::OnFind()
{
	std::vector<std::string> vFound;
	std::string sD=ebDir.GetData().ToString().ToStd();
	std::string sF=ebFind.GetData().ToString().ToStd();
	bool bS=optSubs.Get();
	bool bC=optCase.Get();
	bool bN=(~radFG==0);
	
	TRIM(sD); TRIM(sF); TRIM(sF, "*?");
	if (!isextant(sD, DE_DIR)) { PromptOK("Invalid directory"); return; }
	if (sF.empty()) { PromptOK("Nothing to find!"); return; }
	
	WaitCursor WC; WC.Show();
	
	if (bN) { spf(sF, "*%s*", sF.c_str()); findfiles(sD, bS, sF, bC, vFound); }
	else grepfiles(sD, bS, sF, bC, vFound);
	
	ShowFiles(vFound);
}

void FindDlg::ShowFiles(const std::vector<std::string> &vFound)
{
	arFind.Clear();
	if (vFound.empty()) arFind.Add(" - nothing found - ");
	else
	{
		struct stat STAT;
		struct tm *ptm;
		std::stringstream ss;
		std::string sSize, sType, sRights, sOwner, sDate;
		
		for (auto f:vFound)
		{
			sSize=sType=sRights=sOwner=sDate="";
			if (lstat(f.c_str(), &STAT)==0)
			{
				sOwner=username(STAT.st_uid);
				sSize=ttos<size_t>(STAT.st_size);
				ss << ((STAT.st_mode & S_IRUSR)?"r":"_") << ((STAT.st_mode & S_IWUSR)?"w":"_") << ((STAT.st_mode & S_IXUSR)?"x":"_"); //speed
				ss << ((STAT.st_mode & S_IRGRP)?"r":"_") << ((STAT.st_mode & S_IWGRP)?"w":"_") << ((STAT.st_mode & S_IXGRP)?"x":"_");
				ss << ((STAT.st_mode & S_IROTH)?"r":"_") << ((STAT.st_mode & S_IWOTH)?"w":"_") << ((STAT.st_mode & S_IXOTH)?"x":"_");
				sRights=ss.str(); ss.str(""); ss.flush();

				ptm = localtime(&STAT.st_mtime);
				ss << (ptm->tm_year+1900) //a #define or variable somewhere?
					<< "-" << (((ptm->tm_mon+1)<=9)?"0":"") << (ptm->tm_mon+1)
					<< "-" << ((ptm->tm_mday<=9)?"0":"") << ptm->tm_mday
					<< " " << ((ptm->tm_hour<=9)?"0":"") << ptm->tm_hour
					<< ":" << ((ptm->tm_min<=9)?"0":"") << ptm->tm_min
					<< ":" << ((ptm->tm_sec<=9)?"0":"") << ptm->tm_sec;
				sDate=ss.str(); ss.str(""); ss.flush();

				switch(getdetype(f))
				{
					case DE_FILE: sType="file"; break;
					case DE_DIR: sType="dir"; break;
					case DE_DEVICE: sType="device"; break;
					case DE_PIPE: sType="pipe"; break;
					case DE_LINK: sType="link"; break;
					case DE_SOCKET: sType="socket"; break;
					default: sType="unknown";
				}
			}
			arFind.Add(f.c_str(), sSize.c_str(), sType.c_str(), sRights.c_str(), sOwner.c_str(), sDate.c_str());
		}
	}
}
