
#ifndef _linuxsys_h_
#define _linuxsys_h_


#include <string>
#include <vector>
#include <map>


extern std::string ls_err_text; //last error reason (may not be current)
#define INIT_PREP_BUSY 0xffffff

//-------------------------------------------------------------------------------user & process
int this_userid();
int this_appid();
const std::string this_appname();

const std::string username(int uid=this_userid());
const std::string homedir(int uid=this_userid());

//const std::string shellapp(); ---termapp(); terminal (xterm/konsole/...)


//-------------------------------------------------------------------------------dirs & files
enum DE_TYPE
{
	DE_ERROR=0,
	DE_EXIST=1,
	DE_FILE,
	DE_DIR,
	DE_DEVICE,
	DE_PIPE,
	DE_LINK,
	DE_SOCKET,
};

bool isextant(const std::string &sDE, DE_TYPE det=DE_EXIST);
DE_TYPE getdetype(const std::string &sDE);
bool existdir(const std::string &sD);
bool createdir(const std::string &sD);
bool deletedir(const std::string &sD);

bool existfile(const std::string &sF);
bool createfile(const std::string &sF);
bool deletefile(const std::string &sF);

const std::vector<std::string> splitpath(const std::string &sP);

void movede(const std::string &sDE, const std::string &sTgt);
void deletede(const std::string &sDE);
const std::string getdename(const std::string &sDE);
const std::string getdepath(const std::string &sDE);

void backup(const std::string &sDE, const std::string &sTgt);
void copydir(const std::string &sDF, const std::string &sDT);
bool copyfile(const std::string &sF, const std::string &sT);

bool issub(const std::string &sSub, const std::string &sParent);

void findfiles(const std::string &sD, bool bS, const std::string &sN, bool bN, std::vector<std::string> &vFound);
void grepfiles(const std::string &sD, bool bS, const std::string &sC, bool bC, std::vector<std::string> &vFound);


//-------------------------------------------------------------------------------file-info
bool system_has_tool(const std::string &t);

enum FT_TYPE //regularly used/needed types
{
	FT_EXECUTABLE=1,
	FT_SHELL_SCRIPT,
	FT_PERL_SCRIPT,
	//..
};
bool isfiletype(const std::string &sF, FT_TYPE ftt);
const std::string getfiletypeinfo(const std::string &sF);
bool isvalidname(const std::string &sN);
bool isexec(const std::string &sF);
bool isshell(const std::string &sF); //shell-script
bool isperl(const std::string &sF);
bool isexecutable(const std::string &sF);

const std::string mimetype(const std::string &sF);

//--------------------------------------
void prepexecs(); //call this _once_only_ for life of app (pre-builds map of mime-type to applications)-may take a minute
//NB: see definitions - getexecs..() is dependent on prepexecs() completing (called at app-start (see main.cpp))
size_t getexecs(const std::string &sFile, std::map<std::string, std::string> &ms, bool bSearchAgain=false);
size_t getexecs_possible(const std::string &sFile, std::map<std::string, std::string> &ms); //poss. substitutes
//--------------------------------------

typedef int U_RIGHTS;
enum //U_RIGHTS //per entry
{
	R_NONE	=0,
	R_FOPEN	=1,		//=> file: can (open/copy)
	R_FMOD	=3,		//=> file: can ((open/copy)/add/edit/delete)
	R_FRUN	=4,		//=> file: can execute (elf or script)
	R_DOPEN	=8,		//=>dir: can (open/copy)
	R_DMOD	=24,	//=>dir: can ((open/copy)/add/edit/delete)
};
U_RIGHTS getrights(const std::string &sDE);
#define CAN_OPEN(R) (((R&R_FOPEN)==R_FOPEN)||((R&R_DOPEN)==R_DOPEN))
#define CAN_MODIFY(R) (((R&R_FMOD)==R_FMOD)||((R&R_DMOD)==R_DMOD))
#define CAN_RUN(R) ((R&R_FRUN)==R_FRUN)
#define CAN_OPEN_FILE(R) ((R&R_FOPEN)==R_FOPEN)
#define CAN_MODIFY_FILE(R) ((R&R_FMOD)==R_FMOD)
#define CAN_OPEN_DIR(R) ((R&R_DOPEN)==R_DOPEN)
#define CAN_MODIFY_DIR(R) ((R&R_DMOD)==R_DMOD)


//-------------------------------------------------------------------------------system-calls
const std::string SysCmd(const std::string &cmd);
void SysTerm(const std::string &command);
void CleanupSysTerms(); //NB: if SysTerm(..) can be used, this MUST be called at end of app.

void RunApp(const std::string sApp, const std::string sParm="");
void RunAppFile(const std::string sApp, const std::string sFile);

#endif //#ifndef _linuxsys_h_


