#ifndef _sfm_tabxctrl_h_
#define _sfm_tabxctrl_h_

#include <CtrlLib/CtrlLib.h>
#include <TabBar/TabBar.h>


using namespace Upp;

#include "picbutton.h"
#include "dircontent.h"

#include <string>
#include <map>


struct TabXCtrl : public TabCtrl
{
	typedef TabXCtrl CLASSNAME;

	std::map<const std::string, PicButton> tabxs;
	std::map<const std::string, DirContent*> PDC;

	TabXCtrl();
	virtual ~TabXCtrl();

	bool Key(dword key, int);
	bool CheckIsTabOpen(const std::string &sDir, bool bActivate=true);
	void AddTab(const std::string &sName, const std::string &sDir, bool bCanClose=true, const std::string &sFocusKey="");
	void RemoveTab(const std::string &sName);
	void OnCloseButton(PicButton *pX);

};


#endif
