
#include "picbutton.h"


PicButton::PicButton() { sData=""; ldn=bsel=false; }
PicButton::PicButton(const Image &img) { pic=img; SetRect(pic.GetSize()); }

/********************/PicButton& PicButton::
SetPic(const Image &img)
{
	pic = img;
	sData="";
	ldn=bsel=false;
	Refresh();
	return *this;
}

/********************/void PicButton::
Paint(Draw& w)
{
	Size sz = GetSize();
	Size psz = pic.GetSize();
    w.DrawRect(sz, SColorFace());
    Color lt=White(), br=Gray();
    
	if (ldn) { lt=Gray(); br=White(); }
	else if (bsel) { lt=br=Black(); }

	w.DrawLine(0, 0, sz.cx-1, 0, 1, lt);
	w.DrawLine(0, 0, 0, sz.cy-1, 1, lt);
	w.DrawLine(0, sz.cy-1, sz.cx-1, sz.cy-1, 1, br);
	w.DrawLine(sz.cx-1, 0, sz.cx-1, sz.cy-1, 1, br);

	w.DrawImage((sz.cx-psz.cx)/2, (sz.cy-psz.cy)/2, pic);
}

void PicButton::Select(bool b)
{ 
	bsel=b; 
	Refresh(); 
}

void PicButton::LeftDown(Point p, dword keyflags) { ldn=true; Refresh(); }
void PicButton::LeftUp(Point p, dword keyflags) { ldn=false; Refresh(); WhenPush(this); }
void PicButton::MouseEnter(Point p, dword keyflags) { /*...*/ }
void PicButton::MouseLeave() { ldn=false; Refresh(); }

