
#include "util.h"

#include <cstdarg>
#include <algorithm>
#include <ctime>



//-----------------------------------------------------------------------------
//statusbar access..
#include "sfm.h"
extern SFM *pSFM; //in main.cpp
void ShowStatusText(const std::string &s)
{
	pSFM->ShowStatus(s.c_str());
}

void ClearStatusText()
{
	pSFM->ShowStatus(" ");
}


//-----------------------------------------------------------------------------
const std::string spf(const std::string &fmt, ...)
{
    size_t n, len=100;
	std::string s;
    bool b=false;
    va_list marker;
    while (!b)
    {
        s.resize(len);
        va_start(marker, fmt);
        n = vsnprintf((char*)s.c_str(), len, fmt.c_str(), marker);
        va_end(marker);
        if ((n>0) && ((b=(n<len))==true)) s.resize(n); else len*=2;
    }
    return s;
}

void spf(std::string &S, const std::string &fmt, ...)
{
    size_t n, len=100;
	std::string s;
    bool b=false;
    va_list marker;
    while (!b)
    {
        s.resize(len);
        va_start(marker, fmt);
        n = vsnprintf((char*)s.c_str(), len, fmt.c_str(), marker);
        va_end(marker);
        if ((n>0) && ((b=(n<len))==true)) s.resize(n); else len*=2;
    }
    S = s;
}

void spfa(std::string &S, const std::string &fmt, ...)
{
    size_t n, len=100;
	std::string s;
    bool b=false;
    va_list marker;
    while (!b)
    {
        s.resize(len);
        va_start(marker, fmt);
        n = vsnprintf((char*)s.c_str(), len, fmt.c_str(), marker);
        va_end(marker);
        if ((n>0) && ((b=(n<len))==true)) s.resize(n); else len*=2;
    }
	S += s;
}

void ReplacePhrase(std::string& S, const std::string& sPhrase, const std::string& sNew)
{ //replaces EACH occurence of sPhrase with sNew
	size_t pos = 0, fpos;
	std::string s=S;
	while ((fpos = s.find(sPhrase, pos)) != std::string::npos)
	{
		s.replace(fpos, sPhrase.size(), sNew);
		pos = fpos + sNew.length();
	}
	S=s;
}

std::string& lcase(std::string& s)
{
	std::transform(s.begin(), s.end(), s.begin(), [](char a){return((((a>='A')&&(a<='Z'))?(a+32):a));});
	return s;
}

void LTRIM(std::string& s, const char *sch)
{
	std::string ss=sch;
	int i=0, n=s.length();
	while ((i<n) && (ss.find(s.at(i),0)!=std::string::npos)) i++;
	s = (i>0)?s.substr(i,n-i):s;
}

void RTRIM(std::string& s, const char *sch)
{
	std::string ss=sch;
	int n = s.length()-1;
	int i=n;
	while ((i>0) && (ss.find( s.at(i),0)!=std::string::npos)) i--;
	s = (i<n)?s.substr(0,i+1):s;
}

void TRIM(std::string& s, const char *sch) { LTRIM(s, sch); RTRIM(s, sch); }

size_t splitslist(const std::string &list, char delim, std::vector<std::string> &vs, bool bIncEmpty)
{
	std::stringstream ss(list);
	std::string s;
	//NB: do not clear vs - may be preset with defaults
	while (std::getline(ss, s, delim)) { TRIM(s); if (!s.empty()||bIncEmpty) vs.push_back(s); }
	return vs.size();
}

bool IsInStrSet(const std::string &sE, const std::string &sSet)
{
	if (sE.empty()) return false;
	std::string s;
	spf(s, "[%s]", sE.c_str());
	return (sSet.find(s.c_str()) != std::string::npos);
}

const std::string TimeStamp()
{
	time_t t;
	struct tm *ptm;
	char buf[40];
	std::string s;
	time(&t);
	ptm = localtime(&t);
	strftime(buf, 40, "%Y%m%d%H%M%S", ptm);
	s=(char*)buf;
	return s;
}

const std::string get_unique_name()
{
	std::string sun="";
	struct timespec ts;
	clock_gettime(0, &ts);
	spf(sun, "%s%0X", TimeStamp().c_str(), ts.tv_nsec);
	return sun;
}
