
#include "controlpanel.h"

#define  IMAGEFILE  <sfm/sfm.iml>
#define  IMAGECLASS CTRLImg
#include <Draw/iml.h>


ControlPanel::ControlPanel()
{
	CtrlLayout(*this);
	SetFrame(ThinInsetFrame());

	btnFind.SetPic(CTRLImg::PicFind());

	btnHome.SetPic(CTRLImg::PicHome());
	btnRefresh.SetPic(CTRLImg::PicRefresh());

	btnNodesTop.SetPic(CTRLImg::PicNodesTop());
	btnNodesBot.SetPic(CTRLImg::PicNodesBot());
	btnNodesNone.SetPic(CTRLImg::PicNodesNone());

	ebCurPath.SetEditable(false);
}

void ControlPanel::Paint(Draw& w)
{
	Size sz = GetSize();
    w.DrawRect(sz, SColorFace());
	//...
}

void ControlPanel::CurPath(const String s) { ebCurPath <<= s; }
const String ControlPanel::CurPath() { return ~ebCurPath; }

void ControlPanel::SelectNTBN(char tbn)
{
	btnNodesTop.Select(false);
	btnNodesBot.Select(false);
	btnNodesNone.Select(false);
	if (tbn=='T') btnNodesTop.Select(true);
	else if (tbn=='B') btnNodesBot.Select(true);
	else btnNodesNone.Select(true);
}