#ifndef _sfm_util_h_
#define _sfm_util_h_

#include <string>
#include <vector>
#include <sstream>


//statusbar access..
void ShowStatusText(const std::string &s);
void ClearStatusText();
//..add more as needed

const std::string spf(const std::string &fmt, ...);
void spf(std::string &s, const std::string &fmt, ... );
void spfa(std::string &s, const std::string &fmt, ... );
void ReplacePhrase(std::string& sS, const std::string& sPhrase, const std::string& sNew);
std::string& lcase(std::string& s);
#define TRIM_WHITESPACE " \t\n\r"
void LTRIM(std::string& s, const char *sch=TRIM_WHITESPACE);
void RTRIM(std::string& s, const char *sch=TRIM_WHITESPACE);
void TRIM(std::string& s, const char *sch=TRIM_WHITESPACE);
size_t splitslist(const std::string &list, char delim, std::vector<std::string> &vs, bool bIncEmpty=true);
bool IsInStrSet(const std::string &sE, const std::string &sSet);

template< typename T > const T stot(const std::string &str)
{
    std::istringstream ss(str);
    T ret;
    ss >> ret;
    return ret;
};

template< typename T > const std::string ttos(const T &v)
{
    std::ostringstream ss;
    ss << v;
    return ss.str();
};

const std::string TimeStamp();
const std::string get_unique_name();


#endif
