
#include "custom.h"
#include "linuxsys.h"
#include "util.h"

#include <fstream>

Custom custom; //global

Custom::Custom()
{
	bdirty=false;
	bhasexecs=false;

	exd=EXD_NONE;
	bShowHeader=true;
	bShowTreelines=true;
	
}

Custom::~Custom()
{
	//if (bdirty) Save(); --- rather call explicitly
}

void Custom::Load()
{
	std::string sf=homedir(), s;
	sf+=(sf[sf.size()-1]=='/')?"":"/";
	sf+=".sfm/custom.config";
	if (!isextant(sf, DE_FILE)) return;
	std::ifstream ifs(sf.c_str());
	while (ifs.good())
	{
		std::getline(ifs, s);
		lcase(s);
		if (s.find("showfiles")!=std::string::npos) exd=(s.find("first")!=std::string::npos)?EXD_FIRST:(s.find("last")!=std::string::npos)?EXD_LAST:EXD_NONE;
		if (s.find("showheader")!=std::string::npos) bShowHeader=(s.find("false")!=std::string::npos)?false:true;
		if (s.find("showtreelines")!=std::string::npos) bShowTreelines=(s.find("false")!=std::string::npos)?false:true;
		
	}
	bhasexecs=load_execs();
}

void Custom::Save()
{
	std::string sf=homedir();
	sf+=(sf[sf.size()-1]=='/')?"":"/";
	sf+=".sfm";
	if (!isextant(sf, DE_DIR)) createdir(sf);
	sf+="/custom.config";
	deletefile(sf);
	std::ofstream ofs(sf.c_str());
	if (ofs.good())
	{
		ofs << "showfiles=" << ((exd==EXD_FIRST)?"first":(exd==EXD_LAST)?"last":"none") << "\n";
		ofs << "showheader=" << ((bShowHeader)?"true":"false") << "\n";
		ofs << "showtreelines=" << ((bShowTreelines)?"true":"false") << "\n";
		
	}
	save_execs();
	bdirty=false;
}

bool Custom::load_execs()
{
	std::string sf=homedir(), s="", sm, st, sn, sx;
	sf+=(sf[sf.size()-1]=='/')?"":"/";
	sf+=".sfm/execassocs.xml"; //use const var
	if (!isextant(sf, DE_FILE)) return false;
	std::ifstream ifs(sf.c_str());
	mtx.clear();
	while (ifs.good())
	{
		sx="";
		std::getline(ifs, s); TRIM(s);
		if (s.substr(0,3)=="<m ") { sm=s.substr(3); TRIM(sm," >"); }
		if (s.substr(0,3)=="<t ") { st=s.substr(3); TRIM(st," >"); }
		if (s.substr(0,3)=="<n>") { sn=s.substr(3); TRIM(sn," </n>"); }
		if (s.substr(0,3)=="<x>") { sx=s.substr(3); RTRIM(sx," </x>"); }
		if (!sx.empty()) mtx[sm][st][sn]=sx;
	}
	return (mtx.size()>0);
}

void Custom::save_execs() ///MTX; //..[mime]->>[type]->>[name]=executable-full-path
{
	if (!mtx.empty())
	{
		std::string sf=homedir();
		sf+=(sf[sf.size()-1]=='/')?"":"/";
		sf+=".sfm";
		if (!isextant(sf, DE_DIR)) createdir(sf);
		sf+="/execassocs.xml";
		deletefile(sf);
		std::ofstream ofs(sf.c_str());
		if (ofs.good())
		{
			ofs << "<mtx>\n";
			for (auto m:mtx)
			{
				ofs << "\t<m " << m.first << ">\n";
				for (auto t:m.second)
				{
					ofs << "\t\t<t " << t.first << ">\n";
					for (auto f:t.second)
					{
						ofs << "\t\t\t<n>" << f.first << "</n>\n";
						ofs << "\t\t\t<x>" << f.second << "</x>\n";
					}
					ofs << "\t\t</t>\n";
				}
				ofs << "\t</m>\n";
			}
			ofs << "</mtx>\n";
		}
	}
}


