
#include "sfm.h"
#include "linuxsys.h"
#include "util.h"
#include "custom.h"

#include <sys/types.h>
#include <sys/wait.h>
#include <thread>
#include <chrono>


//==============================================================================================
//zombie-killer (see: linuxsys::RunApp/RunAppFile)
bool OutOfAmmo=false;
void HeadShot()
{
	while (!OutOfAmmo)
	{
		waitpid(-1, 0, WNOHANG);
		std::this_thread::sleep_for(std::chrono::milliseconds(100));
	}
}

extern bool b_prepexecs_busy; //in linuxsys.cpp
void terminit() { while (b_prepexecs_busy) std::this_thread::sleep_for(std::chrono::milliseconds(10)); }

Color Amber() { return Color(255, 126, 0); }

void showinitstatus(SFM *psfm)
{ //because this is fun ... bells & whistles & flashing lights ...
	LED led(Amber());
	psfm->ShowStatusLed(&led, "initializing ..", true);
	while (b_prepexecs_busy) { std::this_thread::sleep_for(std::chrono::milliseconds(200)); }
	led.col=Green(); psfm->ShowStatusLed(&led, "initializing done");
	std::this_thread::sleep_for(std::chrono::milliseconds(1000));
	psfm->ShowStatusLed();
	psfm->ShowStatus(" ");
}

//for global access to statusbar funcs..
SFM *pSFM;

GUI_APP_MAIN
{
	custom.Load();
	SFM sfm;
	pSFM=&sfm;
	if (!custom.bhasexecs)
	{
		b_prepexecs_busy=true;
		std::thread(prepexecs).detach();
		std::thread(showinitstatus,&sfm).detach();
	}
	std::thread KillZombieWith(HeadShot);
	sfm.Run();
	if (b_prepexecs_busy) std::thread waitinit(terminit);
	OutOfAmmo=true;
	KillZombieWith.join();
}

