
#include "sfm.h"
#include "custom.h"

#include <thread>
#include <chrono>


#define  IMAGEFILE  <sfm/sfm.iml>
#define  IMAGECLASS FMImg
#include <Draw/iml.h>


//-------------------------------------------------------------------------------
LED::~LED() { if (bFlash) bFlash=false; }

void LED::Paint(Draw &drw)
{
	drw.DrawEllipse(1, 1, 14, 14, White(), Null, White());
	drw.DrawEllipse(2, 2, 12, 12, Gray(), Null, Gray());
	drw.DrawEllipse(3, 3, 10, 10, col, Null, col);
}

void LED::do_flash(LED *pl)
{
	auto ll=[](int n){if(n<255)n+=((255-n)/2);return n;}; //lighter
	auto dd=[](int n){if(n)n-=(n/2);return n;}; //darker
	Color norm=pl->col, lite, dark;
	lite=Color(ll(norm.GetR()), ll(norm.GetG()), ll(norm.GetB()));
	dark=Color(dd(norm.GetR()), dd(norm.GetG()), dd(norm.GetB()));
	int i=0;
	while (pl->bFlash)
	{
		switch (i)
		{
			case 0: pl->col=norm; break;
			case 1: pl->col=lite; break;
			case 2: pl->col=norm; break;
			case 3: pl->col=dark; break;
		}
		i++; if (i>=4) i=0;
		pl->Refresh();
		std::this_thread::sleep_for(std::chrono::milliseconds(100));
	}
}

void LED::Flash(bool bFlash)
{
	this->bFlash=bFlash;
	if (bFlash) std::thread(do_flash, this).detach();
	Refresh();
}


//-------------------------------------------------------------------------------
SFM::SFM()
{
	Icon(FMImg::SFMICON());
	Title("SFM");
	SetRect(0,0,1000,800);
	Sizeable();
	CenterScreen();
	
	AddFrame(statusbar);

	Add(Tabs.HSizePosZ().VSizePosZ());
	
	Tabs.AddTab("Root", "/", false); //default start with current system-root, not-closeable
	
}

SFM::~SFM() { custom.Save(); }

void SFM::ShowStatus(const String &S) { statusbar=S; }

void SFM::ShowStatusLed(LED *led, const String &S, bool bFlash)
{
	static LED *L=nullptr;
	if (led)
	{
		L=led;
		statusbar.Add((*led).LeftPos(1,16).TopPos(1,16));
		led->Flash(bFlash);
		if (!S.IsEmpty()) { String s="    "; s+=S; statusbar=s; }
	}
	else
	{
		bFlash=false;
		if (L) statusbar.RemoveChild(L);
	}
}

