
#include "tabxctrl.h"
#include "util.h"

#define  IMAGEFILE  <sfm/sfm.iml>
#define  IMAGECLASS TXImg
#include <Draw/iml.h>


TabXCtrl::TabXCtrl() { }
TabXCtrl::~TabXCtrl() { tabxs.clear(); for (auto p:PDC) delete p.second; PDC.clear(); }

void TabXCtrl::ApplyCustom()
{
	for (auto p:PDC) p.second->ApplyCustom();
}

bool TabXCtrl::Key(dword key, int c) { return GetActiveCtrl()->Key(key, c); } //keyboard keys!

bool TabXCtrl::CheckIsTabOpen(const std::string &sRK, bool bActivate)
{
	std::string K=sRK;
	K[0]='R';
	auto itp=PDC.find(K.c_str());
	if (itp!=PDC.end())
	{
		if (bActivate) TabCtrl::Set(*PDC[K]);
		return true;
	}
	return false;
}

void TabXCtrl::AddTab(const std::string &sName, const std::string &sKey, bool bCanClose, const std::string &sFocusKey)
{
	std::string sDir=(sKey[0]=='/')?sKey:sKey.substr(1);
	std::string sRK="R"; sRK+=sDir;
	if (CheckIsTabOpen(sRK)) return;
	for (auto &p:PDC) { p.second->SetLock(sKey, true); }
	PDC[sRK]=new DirContent();
	PDC[sRK]->sRNDir=sRK;
	PDC[sRK]->WhenCustomized << THISBACK(ApplyCustom);
	PDC[sRK]->WhenOpenTab << THISBACK(AddTab);
	PDC[sRK]->CheckIsTabOpen << THISBACK(CheckIsTabOpen);
	TabCtrl::Item &IT=Add((*PDC[sRK]).HSizePosZ().VSizePosZ(), sName.c_str());
	if (bCanClose)
	{
		tabxs[sRK]=PicButton(TXImg::PicX());
		tabxs[sRK].Data(sRK);
		tabxs[sRK].WhenPush << THISBACK(OnCloseButton);
		IT.SetCtrl(tabxs[sRK]);
	}
	PDC[sRK]->Load();
	TabCtrl::Set(*PDC[sRK]); //make active/focus
	if (!sFocusKey.empty()) PDC[sRK]->FocusNodeKey(sFocusKey);
}

void TabXCtrl::RemoveTab(const std::string &sRK)
{
	auto itp=PDC.find(sRK.c_str()); if (itp!=PDC.end()) { Remove(*PDC[sRK]); delete (*itp).second; PDC.erase(itp); }
	auto itx=tabxs.find(sRK.c_str()); if (itx!=tabxs.end()) tabxs.erase(itx);
}

void TabXCtrl::OnCloseButton(PicButton *pX)
{
	if (pX)
	{
		std::string sRK=pX->Data();
		RemoveTab(sRK);
		sRK[0]='N';
		for (auto &p:PDC) p.second->SetLock(sRK, false);
	}
}

