#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#include "treegrid.h"

struct TreegridDemo : public TopWindow
{
	typedef TreegridDemo CLASSNAME;
	TreeGrid treegrid;
	TreegridDemo();
	virtual ~TreegridDemo() {}
};

TreegridDemo::TreegridDemo()
{
	Title("TreegridDemo");
	SetRect(0,0,600,600);
	Sizeable();

	Add(treegrid.HSizePos().VSizePos());

	treegrid.AddColumn("Column 1", 200).Sorting();
	treegrid.AddColumn("Column 2", 200).Sorting();
	treegrid.AddColumn("Column 3", 200).Sorting();

	//indentation is just for readability..
	//AddNode can fail in two cases: a supplied key is already used, and when out-of-memory
	Node node=treegrid.AddNode(0, "tree-label (column 1-cell)", /*0 => at root of tree */
                             "key (if you want one)",
                             "a-cell",
                             "b-cell");
                         
		treegrid.AddNode(node, "tree sub-node label", /*node => parent of new node*/
                              "", /*empty user-key - keys are auto-generated if empty*/
                              "c-cell",
                              "d-cell");

		treegrid.AddNode(node, "sub label1",
                              "",
                              "e-cell",
                              "f-cell");

		treegrid.AddNode(node, "sub label2"); /*no key and you can have blank values*/
			//must give key (even empty string) if you want values
			//empty cells corresponding to the columns will be silently created

	node=treegrid.AddNode(0, "another tree-label",
                        "",
                        "a-cell",
                        "a-cell",
                        "extra cell - you can have extra cells for private data");

		treegrid.AddNode(node, "tree sub-node label", "", "col2-cell", "col3-cell");
		Node node1=treegrid.AddNode(node, "tree sub-node label", "", "col2-cell", "col3-cell");
			treegrid.AddNode(node1, "node n1", "", "value", "value");
		treegrid.AddNode(node, "A Label", "", "col2-cell", "col3-cell");

	treegrid.RefreshTreeGrid();
}

GUI_APP_MAIN
{
	TreegridDemo().Run();
}