#include <Core/Core.h>
#include <CtrlLib/CtrlLib.h>
using namespace Upp;

#define LAYOUTFILE <guitest/test.lay>
#include <CtrlCore/lay.h>

class MyWindow : public WithLayout<TopWindow> {
	typedef MyWindow CLASSNAME;

public:
	MyWindow(){
		CtrlLayout(*this, "");
	}
	
	void LeftDown(Point, dword) {
		StoreToJson();
	}
	
	void StoreToJson() {
		Json json;
		for (Ctrl *q = GetFirstChild(); q; q=q->GetNext()) {
			if (dynamic_cast<EditField *> (q)) {
				String id = q->GetLayoutId();
				if (id.GetCount())
					json(id, ~*q);
			}
		}
		SelectFileOut out("*.*");
		if (out.IsOpen())
			out << json << "\n";
	}
};

GUI_APP_MAIN {
	MyWindow().Run();
}