#include "Barcode.h"
NAMESPACE_UPP



void ITF::Prepare()
{
	DrawingDraw w(1,1);
	if(!data.IsEmpty())
	{
		int h=barRatio;
		Size textSize=GetTextSize(text, font);
		if(!text.IsEmpty())
		{
			h+=2+textSize.cy;
		}
		
		int width=std::max(BarcodeWidth(),textSize.cx);
		w.Create(width,h);
		DoDraw(w, width);
		
	}
	draw.Create<Drawing>()=w;
	//const_cast<Code128&>(*this).draw.Create<Drawing>()=w;
}

void ITF::SetText(const char* s, int len)
{
	
	if(len>=0)
	{
		data=String(s,len);
	}else
		data=s;
	// check if all digits
	for(int i=0; i<data.GetLength(); ++i)
		if(data[i]>'9' || data[i]<'0')
		{
			data.Clear();
			break;
		}
	if(data.GetLength() & 1 )// of odd length
	{
		data='0'+data;
	}
	text=data;
}

ITF& ITF::WideBarWidth(int width)
{
	ASSERT_(width==2 || width==3,"the only valid values for ITF wide bar width are 2 and 3"); // debug time check
	if(width!=3) // runtime correction. silently.
		width=2;
	truncated=width==3;
	return *this;
}

int ITF::BarcodeWidth()const
{
	int wide=WideBarWidth();
	
	return data.GetLength()*(3+2*wide)+8/* for start and stop*/+ (noQuietZone?0:10);
}

ITF& ITF::AddCheckSum()
{
	if(!data.IsEmpty())
		data<<UpcCheckDigit(data);
	return *this;
}


struct DC
{
	DC(Draw& d, Color c, int left, int top, int height)
		:d(d),c(c),l(left),t(top),h(height){}
	int l,t,h;// top alway = 0 if top quiet zone is ignored
	Color c;
	Draw& d;
	
	DC& Bar(int width=1){
		d.DrawRect(l,t,width,h,c);
		l += width;
		return *this;
	}
	DC& Blank(int width=1){
		l += width;
		return *this;
	}
};

static char stroke_map[10]={
	//	0	n	n	W	W	n	4+7=11, replaced by 0
	//	1	W	n	n	n	W	1+0=1
	//	2	n	W	n	n	W	2+0=2
	//	3	W	W	n	n	n	1+2=3
	//	4	n	n	W	n	W	4+0=4
	//	5	W	n	W	n	n	1+4=5
	//	6	n	W	W	n	n	2+4=6
	//	7	n	n	n	W	W	7+0=7
	//	8	W	n	n	W	n	1+7=8
	//	9	n	W	n	W	n	2+7=9
	(1<<2) | (1<<3),
	(1<<0) | (1<<4),
	(1<<1) | (1<<4),
	(1<<0) | (1<<1),
	(1<<2) | (1<<4),
	(1<<0) | (1<<2),
	(1<<1) | (1<<2),
	(1<<3) | (1<<4),
	(1<<0) | (1<<3),
	(1<<1) | (1<<3)
};

void ITF::DoDraw(Draw& w, int drawwidth)
{
	Size textSize(0,0);
	if(!text.IsEmpty())
	{
		textSize=GetTextSize( text, font);
		textSize.cy+=2;
	}


	ASSERT(noQuietZone==0 || noQuietZone==1);
	
	
	int left=0;
	int h=barRatio;
	int width=textSize.cx-this->BarcodeWidth();
	if(width>0)
		left+= width/2;
	if(noQuietZone==0)
		left+=5; // skip first quiet zone

	DC dc(w,color,left,0,barRatio);

	dc.Bar().Blank().Bar().Blank();// start nnnn
	
	int ww=WideBarWidth(); // width of wide bar
	for(int i=0; i<data.GetLength();i+=2)
	{
		int m,n;
		m=data[i]-'0';
		n=data[i+1]-'0';
		for(int j=0; j<5; ++j)
		{
			dc.Bar( (stroke_map[m] & (1<<j))/*is stroke wide?*/?ww:1 );
			dc.Blank( (stroke_map[n] & (1<<j))/*is stroke wide?*/?ww:1 );
		}
	}
	
	dc.Bar(ww).Blank().Bar(); // stop Wnn;

	if(textSize.cy!=0)
	{
		w.DrawText((drawwidth-textSize.cx)/2, dc.h+2,text,font,color);
	}
}


END_UPP_NAMESPACE