topic "About AsyncQueue";
[2 $$0,0#00000000000000000000000000000000:Default]
[l288;i1120;a17;O9;~~~.1408;2 $$1,0#10431211400427159095818037425705:param]
[a83;*R6 $$2,5#31310162474203024125188417583966:caption]
[H4;b83;*4 $$3,5#07864147445237544204411237157677:title]
[i288;O9;C2 $$4,6#40027414424643823182269349404212:item]
[b42;a42;2 $$5,5#45413000475342174754091244180557:text]
[l288;b17;a17;2 $$6,6#27521748481378242620020725143825:desc]
[l321;C@5;1 $$7,7#20902679421464641399138805415013:code]
[b2503;2 $$8,0#65142375456100023862071332075487:separator]
[*@(0.0.255)2 $$9,0#83433469410354161042741608181528:base]
[C2 $$10,0#37138531426314131251341829483380:class]
[l288;a17;*1 $$11,11#70004532496200323422659154056402:requirement]
[i417;b42;a42;O9;~~~.416;2 $$12,12#10566046415157235020018451313112:tparam]
[b167;C2 $$13,13#92430459443460461911108080531343:item1]
[i288;a42;O9;C2 $$14,14#77422149456609303542238260500223:item2]
[*@2$(0.128.128)2 $$15,15#34511555403152284025741354420178:NewsDate]
[l321;*C$7;2 $$16,16#03451589433145915344929335295360:result]
[l321;b83;a83;*C$7;2 $$17,17#07531550463529505371228428965313:result`-line]
[l160;*C+117 $$18,5#88603949442205825958800053222425:package`-title]
[2 $$19,0#53580023442335529039900623488521:gap]
[C2 $$20,20#70211524482531209251820423858195:class`-nested]
[b50;2 $$21,21#03324558446220344731010354752573:Par]
[{_}%EN-US 
[s2; AsyncQueue&]
[s6;  &]
[s2; [A+117 Rationale]&]
[s0;# U`+`+ provides a rich set of core classes, including synchronisation 
tools and primitives designed mainly with multithreading in mind. 
Considering the general trends in, and demands of, modern computing, 
this is perfectly reasonable, if not imperative. When done properly, 
multithreading can and usually does give the best performance/cost 
ratio with a negligable overhead. Hovewer, multithreading is 
not always the optimal solution, and has its own disadvantages. 
For one, it is relatively difficult to write and debug a multithreaded 
code, as multithreading bring in its own set of problems such 
as classic concurrency problems which must be taken care of with 
extreme caution. Hence the increase of complexity. Moreover, 
multithreading models does not always scale well. Not every asynchronous 
operation or applicaton requires, or benefits from multithreading. 
Enter [^topic`:`/`/AsyncQueue`/src`/AsyncQueue`$en`-us`#Upp`:`:AsyncQueue`:`:class^ A
syncQueue].&]
[s6;# &]
[s2; [A+117 Aim]&]
[s0;# [^topic`:`/`/AsyncQueue`/src`/AsyncQueue`$en`-us`#Upp`:`:AsyncQueue`:`:class^ Asy
ncQueue ]helper class does not aspire to provide an alternative 
to the existing multithreading classes in U`+`+. Rather it is 
meant to be a small addition to the arsenal of synchronisation 
tools in the [^topic`:`/`/Core`/srcdoc`/CoreTutorial`$en`-us^ Core] 
package, providing through a [/ standardized interface] a simple 
yet flexible asynchronous model targeting single`-threaded component 
and application development, including but not limited to common 
socket operations, where multithreading either is not desirable 
or can easily get costly.&]
[s0;# &]
[s0;# &]
[s2; [A+117 Features, Highlights, and Usage]&]
[s6;# &]
[s0;#i150;O0; [* AsyncQueue implements a simple job queue model.] In 
this context, `"job`" is defined simply as [/ something to be done 
using a certain method or function]. Thus the `"Job`" concept 
is implemented using U`+`+ style [^topic`:`/`/Core`/src`/Callbacks`$en`-us`#Callback`:`:class^ C
allbacks] which can take up to 5 arguments. Accordingly, the 
job queue is implemented using a [^topic`:`/`/Core`/src`/Vector`$en`-us`#Vector`:`:class^ V
ector] containing callbacks. Using U`+`+ callbacks under C`+`+11 
or later versions of C`+`+ language also [/ allows us to utilize 
lambda callbacks][*/  ]without any effort. While U`+`+ callbacks 
can accept maximun 5 arguments, and this is sufficient for most 
operations, [^topic`:`/`/Core`/src`/Value`$en`-us^ Value][^topic`:`/`/Core`/src`/ValueArray`$en`-us`#ValueArray`:`:class^ `[
Array`]] or [* std`::tuple] (from C`+`+11 on) can be used for surpassing 
the initial limitation if necessary. [/ Note that jobs themselves 
are executed sequentially, not asynchronously].&]
[s0;  &]
[s7; -|Vector<Callback> job`_queue; &]
[s0;3%- &]
[s0;#i150;O0; [* AsyncQueue uses a dynamically re`-programmable job 
queue model. ]Using a [^topic`:`/`/Core`/src`/ValueMap`$en`-us`#ValueMap`:`:class^ V
ector] to implement the job queue allows a great flexibility 
in managing jobs. By this way,  (re`-)programing job sequences 
becomes trivial; pending jobs can be easily manipulated on`-the`-fly. 
For example, an overall asychronous operation can be either a 
single job or consisted of a set/sequence of jobs. In the latter 
case the job queue may require intervention when a given job 
fails but the failure is not deemed a fatal error (no need to 
halt), or an interaction with the user is required to determine 
the direction of the overall operation.&]
[s0; &]
[s7; -|// Programming the job queue is easy.&]
[s7; -|// This pseudo`-code programs a hypothetical fopen() `+ fstat() 
`+ fclose() sequence.&]
[s7; &]
[s7; -|ClearQueue();&]
[s7; -|AddJob() `= THISBACK3(CmdOpen, file`_name, flags, mode);&]
[s7; -|AddJob() `= THISBACK1(CmdStat, file`_handle);&]
[s7; -|AddJob() `= THISBACK1(CmdClose, file`_handle);&]
[s7; -|&]
[s7; -|...&]
[s7; &]
[s7; -|// Manipulating the job queue is also easy.&]
[s7; -|// Let us assume that we have a single operation consisting 
of five sequential jobs in the job queue &]
[s7; -|// Let us also assume that the current job is failed but this 
failure is not a fatal error. &]
[s7; -|// And all it requires us is to replace the pending job no 
3, with another job&]
[s7; -|// Let this alternative job be a some sort of simple error 
logging.&]
[s7; -|&]
[s7; -|RemoveJob(3);&]
[s7; -|InsertJob(3) `= THISBACK2(CmdLogError, `-1, `"Job no 3 failed.`");&]
[s7; -|ProcessQueue();&]
[s0; &]
[s0;#i150;O0; [* AsyncQueue aims to standardize a non`-blocking API, 
establishing an easy to use, uniform interface. ]To this end 
it is designed as a base class, exposing a small set of protected 
and even smaller set of public methods. As a side note, the api 
of AsyncQueue class is heavily inspired by the HttpRequest class. 
The set of public methods AsyncQueue exposes is:  [^topic`:`/`/AsyncQueue`/src`/AsyncQueue`$en`-us`#Upp`:`:AsyncQueue`:`:Do`(`)^ D
o()], [^topic`:`/`/AsyncQueue`/src`/AsyncQueue`$en`-us`#Upp`:`:AsyncQueue`:`:InProgress`(`)const^ I
nProgress()], [^topic`:`/`/AsyncQueue`/src`/AsyncQueue`$en`-us`#Upp`:`:AsyncQueue`:`:IsSuccess`(`)const^ I
sSuccess()], [^topic`:`/`/AsyncQueue`/src`/AsyncQueue`$en`-us`#Upp`:`:AsyncQueue`:`:IsFailure`(`)const^ I
sFailure()], and [^topic`:`/`/AsyncQueue`/src`/AsyncQueue`$en`-us`#Upp`:`:AsyncQueue`:`:WhenDo^ W
henDo]. These methods are explained in the api reference. [/ Note 
that a good practice in further standardizing the asynchronous 
interface would be adding the ]`"[* Start]`"[/  prefix to any method 
used for programming the async job queue prior to calling ][/^topic`:`/`/AsyncQueue`/src`/AsyncQueue`$en`-us`#Upp`:`:AsyncQueue`:`:Do`(`)^ D
o()]. For example, a blocking method such as `"Connect`", should 
have its non`-blocking/async counterpart named `"[*/ Start]Connect`". 
Now let us show step by step how to write a simple non`-blocking 
component. (Below is a pseudo`-code):&]
[s0; &]
[s6;#i150;O9; [* 1)]-|AsyncQueue is an abstract base class. This means 
that it has at least one pure virtual method to be defined later. 
In order to utilize this class we need to derive our class from 
it.&]
[s7; &]
[s7; -|class AsyncQueueTest : public AsyncQueue `{&]
[s7; -|-|// ...&]
[s7; -|`}&]
[s7; &]
[s6;#i150;O9; [* 2)]-|Now we need to declare our jobs. As defined above, 
a job is simply `"something to be done using a certain method 
or function.`" So we need to specify a [* method], and its [* arguments] 
if any. For the sake of convenience, we will add the prefix `"[*/ Cmd]`" 
to all private method which we are going to use as `"job`". &]
[s6;i150;O9; &]
[s7; -|// In AsyncQueueTest.h&]
[s7; &]
[s7; -|private:&]
[s7; -|-|void [*/ Cmd]Connect(const String`& host, int port);-|// Plain 
callback (job) one...&]
[s7; -|public:&]
[s7; -|-|[*/ Start]Connect( const String`& host, int port);-|// We will 
define this using both a plain callback and a lambda callback.&]
[s7; &]
[s7;* &]
[s6;i150;O9; [* 3)]-|First we will `"program`" the job queue using the 
[/ StartConnect()] and [/ StartDisconnect()] methods. Second we will 
define the async method (job) [/ CmdConnect()] to be executed. 
However, instead of defining a CmdDisconnect() we will use lambda 
callback.&]
[s7; &]
[s7; -|// In AsyncQueueTest.cpp&]
[s7; -|&]
[s7; -|// a) Using a plain callback.&]
[s7; &]
[s7; -|void AsyncQueueTest`::StartConnect(const String`& host, int 
port) &]
[s7; -|`{-|-|&]
[s7; -|-|ClearQueue();-|-|-|-|-|-|// Clear the job queue.&]
[s7; -|-|AddJob() `= THISBACK2(CmdConnect, host, port);-|// Program 
the queue.-|&]
[s7; -|`}&]
[s7; &]
[s7; -|&]
[s7; -|void AsyncQueueTest`::CmdConnect(const String`& host, int port) 
&]
[s7; -|`{&]
[s7; -|-|int rc `= ConnectToHost(host, port); &]
[s7; -|-|if(rc `=`= 0) `{&]
[s7; -|-|-|// Success! Now we can safely progress the job queue.&]
[s7; -|-|-|ProcessQueue();&]
[s7; -|-|`}&]
[s7; -|-|else&]
[s7; -|-|if(rc !`= EWOULDBLOCK)&]
[s7; -|-|-|// A fatal error has occured. Bailing out!&]
[s7; -|-|-|Halt();-|-|-|&]
[s7; -|`}&]
[s7; &]
[s7; -|// b) Using a lambda (under C`+`+11)-|&]
[s7; &]
[s7; -|void AsyncQueueTest`::StartConnect(const String`& host, int 
port) &]
[s7; -|`{-|-|&]
[s7; -|-|ClearQueue();-|-|-|-|-|-|// Clear the job queue.&]
[s7; -|-|AddJob() << `[`&, host, port`] `{&]
[s7; -|-|-|// Handling non`-blocking calls has a similar programming 
pattern&]
[s7; -|-|-|// under AsyncQueue. &]
[s7; &]
[s7; -|-|-|int rc `= ConnectToHost(host, port); &]
[s7; -|-|-|if(rc `=`= 0) &]
[s7; -|-|-|-|ProcessQueue();&]
[s7; -|-|-|else&]
[s7; -|-|-|if(rc !`= EWOULDBLOCK)&]
[s7; -|-|-|-|Halt();-|&]
[s7; -|-|`}-|-|&]
[s7; -|`}&]
[s7; &]
[s6;i150;O9; [* 4)] Now we can put this code into motion, using 5 concurrent, 
non`-blocking calls.&]
[s7; &]
[s7; -|// In main.cpp&]
[s7; -|&]
[s7; -|// Below pseudo`-code represents the basic steps to start and 
execute an async operation using an execution loop.&]
[s7; &]
[s7; -|String host -|`= `"www.somehost.com`";&]
[s7; -|int port-|`= 8080;&]
[s7; -|Vector<AsyncQueueTest> test`_stack;&]
[s7; &]
[s7; -|for(int i `= 0; i < 5; i`+`+) &]
[s7; -|-|test`_stack.Add().StartConnect(host, port);-|-|// Program the 
queue for the desired operation.&]
[s7; &]
[s7; -|// Now, process the queue...&]
[s7; -|while(!test`_stack.IsEmpty()) `{&]
[s7; -|-|int i `= 0;&]
[s7; -|-|while(i < test`_stack.GetCount()) `{&]
[s7; -|-|-|// Since this example assumes a socket, in a real world application 
we`'d use SocketWaitEvent to `"wait`" here.&]
[s7; -|-|-|AsyncQueueTest`& t `= test`_stack`[i`];&]
[s7; -|-|-|t.Do();&]
[s7; -|-|-|// Check if the operation is in progress.&]
[s7; -|-|-|if(t.InProgress())&]
[s7; -|-|-|-|i`+`+;&]
[s7; -|-|-|else `{&]
[s7; -|-|-|-|if(t.IsSuccess()) `{&]
[s7; -|-|-|-|-|Cout() << `"Connection successful!`\r`\n`";&]
[s7; -|-|-|-|`}&]
[s7; -|-|-|-|else&]
[s7; -|-|-|-|if(t.IsFailure()) `{&]
[s7; -|-|-|-|-|Cout() << `"Connection has failed!`\r`\n`";&]
[s7; -|-|-|-|`}&]
[s7; -|-|-|-|// Remove the finished or failed object.&]
[s7; -|-|-|-|test`_stack.Remove(i);&]
[s7; -|-|-|`}&]
[s7; -|-|`}&]
[s7; -|`}]]