#include "testlist.h"

class ItemDisplay: public Display {
public:
	int DoPaint(Draw& w, const Rect& r, const Value& q,
                                  Color ink, Color paper, dword style) const {
		const String& m = ValueTo<String>(q);
		
		int x = r.left + 3;
		
		Font font = StdFont();
		bool focuscursor = (style & (FOCUS|CURSOR)) == (FOCUS|CURSOR) || (style & SELECT);
		//if (focuscursor)
                    
        if (style & CURSOR) {
			w.DrawRect(r, Blue());
			w.DrawRect(r.left + 1, r.top + 1, r.right - 2, r.bottom - 2, style ? Blend(paper, LtGray) : paper);
        }
        else
            w.DrawRect(r, paper);
        
        w.DrawText(x, r.top + 1, m, font, ink);
        
        x += GetTextSize(m, font).cx;
        x += 3;
        
        return x;
    }
    
    virtual Size GetStdSize(const Value& q) const {
        NilDraw w;
		return Size(DoPaint(w, Rect(0, 0, INT_MAX, INT_MAX), q, Null, Null, 0), Zy(16) + 2);
    }
    
    virtual void Paint(Draw& w, const Rect& r, const Value& q,
                                  Color ink, Color paper, dword style) const {
		DoPaint(w, r, q, ink, paper, style);
    }
};

testlist::testlist()
{
	CtrlLayout(*this, "Window title");
	
	list.NoRoundSize();
	list.NoActiveX();
	list.SetDisplay(Single<ItemDisplay>());
	list.ItemHeight(Zy(16) + 2);
	
	list.Add("aa");
	list.Add("bb");
	list.Add("cc");
	list.Add("dd");
	list.Add("ee");
	list.Add("ff");
}

GUI_APP_MAIN
{
	testlist().Run();
}
