#include <CtrlLib/CtrlLib.h>
#include <TabBar/TabBar.h>
#include <PdfDraw/PdfDraw.h>

#include "TabChild.h"

using namespace Upp;

class MyApp : public TopWindow
{
public:
	MyApp()
	{
		AddFrame(menu);
		AddFrame(status);
		AddFrame(InsetFrame()).Add(clients);
		menu.Set( THISBACK(MenuMain) );
		clients.SizePos();
		clients.StyleDefault().Write().Variant1Crosses();
		Sizeable().Zoomable();
		
		clients.CancelClose=THISBACK(TabCanClose);
		clients.WhenClose=THISBACK(TabWhenClose);
	
		Title(t_("Test")).Maximize();
	}
	~MyApp()
	{
		for(int i=0; i<clients.GetCount(); ++i)
		{
		// ensure all children are new'd, otherwise
		// this has to be revised.
			delete clients.GetCtrl(i);
		}
	}
	
	typedef MyApp CLASSNAME;
	
private:
	MenuBar menu;
	TabBarCtrl clients;
	StatusBar status;
	

	void MenuMain(Bar& b)
	{
		b.Add(t_("System"), THISBACK(MenuSystem));
	}

	void MenuSystem(Bar& b)
	{
		TabChild* c=dynamic_cast<TabChild*>(clients.GetCurrentCtrl());

		b.Add(t_("Client A"), THISBACK(NewClientA));
		//b.Add(t_("Client B"), THISBACK(NewClientB));
		b.Separator();
		
		b.Add(c && c->IsModified(), t_("Save"), CtrlImg::save(), THISBACK(Save))
			.Key(K_CTRL_S);
		b.Separator();
		b.Add(c && c->IsPrintable(), t_("Print"), CtrlImg::print(), THISBACK(Print))
			.Key(K_CTRL_P);
		b.Add(c && c->IsPrintable(), t_("Save as PDF..."), THISBACK(SaveAsPdf));
	}
	
	void NewClientA();
	
//	void NewClientB()
//	{
//	}

	bool TabCanClose(Value key)
	{
		return !clients.GetCtrl(key)->Accept();
	}
	
	void TabWhenClose(Value key)
	{
		// ensure all children are new'd, otherwise
		// this has to be revised.
		delete clients.GetCtrl(key);
	}

	void Print()
	{
		PrinterJob pd;
		TabChild* tab = dynamic_cast<TabChild*>(
			clients.GetCurrentCtrl()
		);
		
		if(tab != nullptr && pd.Execute())
		{
			tab->Print(pd);
		}
	}

	void SaveAsPdf()
	{
		TabChild* tab = dynamic_cast<TabChild*>(
			clients.GetCurrentCtrl()
		);
		FileSel fs;
		
		fs.Type("PDF files", "*.pdf")
			.AllFilesType().DefaultExt("pdf");
		
		if(tab != nullptr && fs.ExecuteSaveAs("Export to PDF"))
		{
			PdfDraw pdf;
			tab->Print(pdf);
			::SaveFile(~fs,pdf.Finish());
		}
	}
	
	void Save()
	{
		TabChild* tab = dynamic_cast<TabChild*>(
				clients.GetCurrentCtrl()
		);
		if(tab && !tab->Save() )
			PromptOK("Save Failed");
		// else
		//	Refresh();
	}
	

	
};

GUI_APP_MAIN
{
	MyApp().Run();
}


class ClientA : public TabChild
{
public:
	ClientA()
	{
		Add(b.SetLabel("Modify").LeftPos(200).TopPos(10));
		b <<= THISBACK(SetModify);
	}
	
	virtual void Paint(Draw& w)
	{
		w.DrawText(5, 5, String().Cat() << "Client A, "
			<< (IsModified() ? "Modified" : "Not Modified")
		);
	}
	
	bool Save()
	{
		ClearModify();
		Refresh();
		return true;
	}
	
	bool IsPrintable() const { return true; }
	
	void Print(Draw& w) { w.DrawText(5,5,"Client A"); }
private:
	Button b;
	
	void SetModify() { this->Ctrl::SetModify(); Refresh(); }
	
	typedef ClientA CLASSNAME;
};

static int64 UniqueKey()
{
	static int64 v;
	//return String().Cat()<<"UK"<<v++;
	return v++;
}


void MyApp::NewClientA()
{
	clients.AddCtrl(*new ClientA, UniqueKey(), "Clent A", Null, "Clients", true);
}
