#include "TabChild.h"

#include <TabBar/TabBar.h>

bool TabChild::IsPrintable()const
{
	return false;
}

void TabChild::Print(Draw& w)
{
}

bool TabChild::Save()
{
	ClearModify();
	return true;
}

// if we memorize the key, we could locate 
// the tab faster, but this way requires
// least on TabChild derivatives and should
// work faster enough.
//
void TabChild::SetTabTitle(const String& txt)
{
	Ctrl * c=this->GetParent();
	if(c)
		c=c->GetParent();
	TabBarCtrl * p;
	if(c &&	(p=dynamic_cast<TabBarCtrl*>(c))!=nullptr)
	{
		// as of 2013-02-05, the TabBarCtrl implementation
		// shows the above logic
		for(int i=0; i<p->GetCount();++i)
		{
			if(p->GetCtrl(i)==this)
			{
				p->SetValue(i,txt);
				break;
			}
		}
	}
}

bool TabChild::Accept()
{
	bool r=true;
	if(IsModified())
	{
		switch(PromptYesNoCancel(GetSavePrompt()))
		{
		case -1: //default=cancel
			r=false;
			break;
		case 1: //Yes
			r=Save();
			break;
		};
	}
	return r;
}

String TabChild::GetSavePrompt()const
{
	return t_("Data is changed. Do you want to save your change?"); 
}
