#include <CtrlLib/CtrlLib.h>
#include "TaskbarButton.h"

enum
{
    UM_TASKBAR = WM_USER + 1024,
};


TaskbarButton::TaskbarButton()
{
    SetRect(0, 0, 16, 16);
    Zero(nid);
    nid.cbSize = sizeof(nid);
    nid.uCallbackMessage = UM_TASKBAR;
    NoWantFocus();
}

TaskbarButton::~TaskbarButton()
{
    Flush(NIM_DELETE);
    nid.uID = 0;
}

TaskbarButton& TaskbarButton::Icon(const Image &img)
{
	icon = img;
    Refresh();
    return *this;
}

TaskbarButton& TaskbarButton::Label(const char *text)
{
    tip = text;
    Refresh();
    return *this;
}

void TaskbarButton::RightDown(Point p, dword keyflags)
{
    MenuBar::Execute(WhenBar, p);
}

void TaskbarButton::Init(HWND hwnd)
{
    nid.hWnd = hwnd;
    nid.uID = 1;
    Flush(NIM_ADD);
}

LRESULT TaskbarButton::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
    if(message == UM_TASKBAR)
        if(lParam >= WM_MOUSEFIRST && lParam <= WM_MOUSELAST)
        {
            LRESULT result = Ctrl::WindowProc(lParam, /*GetMkCode()*/ 0, 0);
            if(IsFullRefresh())
                Flush(NIM_MODIFY);
            return result;
        }
    return Ctrl::WindowProc(message, wParam, lParam);
}

void TaskbarButton::Paint(Draw& draw)
{
    Flush(NIM_MODIFY);
}

void TaskbarButton::LeftDouble(Point pt, dword keyflags)
{
    WhenDouble();
}

void TaskbarButton::LeftUp(Point pt, dword keyflags)
{
    Action();
}

void TaskbarButton::Flush(dword msg)
{
    if(nid.uID)
    {
        nid.uFlags = NIF_ICON | NIF_MESSAGE | NIF_TIP;
        nid.hIcon = icon.GetIcon();
        int len = tip.GetLength();
        memcpy(nid.szTip, tip, len);
        nid.szTip[len] = 0;
        VERIFY(Shell_NotifyIcon(msg, &nid));
    }
}
