#include "ProvaSP.h"

//*****For the serial port**********
#include <iostream>
#include <boost/thread.hpp>
//#include "AsyncSerial.h"
#include "BufferedAsyncSerial.h"

using namespace std;
using namespace boost;
//**********************************

const int NUM_SECONDS = 1;

CONSOLE_APP_MAIN
{
    try {
        BufferedAsyncSerial tico("COM5",
			 9600,
			 boost::asio::serial_port_base::parity(boost::asio::serial_port_base::parity::even), //Parity even
             boost::asio::serial_port_base::character_size(8), //8bit (?)
             boost::asio::serial_port_base::flow_control(boost::asio::serial_port_base::flow_control::none), //Flow control none
             boost::asio::serial_port_base::stop_bits(boost::asio::serial_port_base::stop_bits::one)); //Stop bits 1
        
	    while(true)
	    {
			tico.writeString("TAV R\r");
	        this_thread::sleep(posix_time::seconds(NUM_SECONDS));
			cout<<tico.readString()<<endl;
		}
        tico.close();
    } catch(boost::system::system_error& e)
    {
        cout<<"Error: "<<e.what()<<endl;
        //return 1;
    }
}
