#ifndef _TestScatter2_TestScatter2_h
#define _TestScatter2_TestScatter2_h

#include <Scatter/Scatter.h>

using namespace Upp;

#define LAYOUTFILE <TestScatter2/TestScatter2.lay>
#include <CtrlCore/lay.h>

#define IMAGECLASS MyImages
#define IMAGEFILE <TestScatter2/TestScatter2.iml>
#include <Draw/iml_header.h>

class Tab1 : public WithTab1<ParentCtrl> {
public:

	typedef Tab1 CLASSNAME;

	Tab1();
};

Tab1::Tab1()
{
	CtrlLayout(*this);	
	HSizePos().VSizePos();
	Vector<XY> s1,s2;
	s1<<XY(10,14)<<XY(20,25)<<XY(30,29)<<XY(40,24)<<XY(50,36);
	s2<<XY(20,34)<<XY(30,45)<<XY(40,49)<<XY(50,44)<<XY(60,56);
	scatter1.AddSeries(s1,"series1");
	scatter1.AddSeries(s2,"series2",true,LtRed);
}

double funct1(double x){return (x*x);}
double funct2(double x){return (-x*x);}
double funct3(double x){return 0;}

class Tab2 : public WithTab2<ParentCtrl> {
public:

	typedef Tab2 CLASSNAME;

	Tab2();
};

Tab2::Tab2()
{
	CtrlLayout(*this);	
	HSizePos().VSizePos();
	scatter2.SetRange(12,60);
	scatter2.SetXYMin(-6,-30);
	scatter2.PlotFunction(&funct3,"X Axis",Green,18);
	scatter2.PlotFunction(&funct1,"x^2", Color(28,85,255),6);	
	scatter2.PlotFunction(&funct2,"-X^2",LtRed);	
}

XY para1(double t) {return XY(cos(2*M_PI*t),sin(2*M_PI*t));}
XY para2(double t) {return XY(0.5*cos(6*M_PI*t)+3*t-1, 1.5+0.5*sin(6*M_PI*t));}
XY para3(double t) {return XY(3+(0.5+t)*cos(6*M_PI*t),(0.5+t)*sin(6*M_PI*t));}
XY para4(double t) {return XY(0,-0.25+0.5*t);}
XY para5(double t) {return XY(-0.25+0.5*t,0);}

class Tab3 : public WithTab3<ParentCtrl> {
public:

	typedef Tab3 CLASSNAME;

	Tab3();
};

Tab3::Tab3()
{
	CtrlLayout(*this);	
	HSizePos().VSizePos();
	scatter3.SetRange(7,4);
	scatter3.SetMajorUnits(0.5,0.5);
	scatter3.SetXYMin(-2,-2);
	scatter3.PlotParaFunction(para1,"Circle",Yellow,6,50);
	scatter3.PlotParaFunction(para2,"Coil",White,6,100);
	scatter3.PlotParaFunction(para3,"Spiral",Color::Color(56,170,255),6,150);
	scatter3.PlotParaFunction(para4,"VLine",LtRed,6,2);
	scatter3.PlotParaFunction(para5,"HLine",LtRed,6,2);	
}

class Tab4 : public WithTab4<ParentCtrl> {
public:

	typedef Tab4 CLASSNAME;

	Tab4();
};

Tab4::Tab4()
{
	CtrlLayout(*this);	
	HSizePos().VSizePos();
	scatter4.SetRange(13,50);
	scatter4.SetMajorUnits(1,10);
	scatter4.SetXYMin(0,-20);
	Vector<XY> s1,s2;
	s1<<XY(1,-6)<<XY(2,-4)<<XY(3,2)<<XY(4,8)<<XY(5,8)<<XY(6,15)<<XY(7,20)<<XY(8,25)<<XY(9,14)<<XY(10,10)<<XY(11,3)<<XY(12,-11);;
	scatter4.AddSeries(s1,"2005",true);
	
	s2<<XY(1,-12)<<XY(2,-7)<<XY(3,0)<<XY(4,2)<<XY(5,10)<<XY(6,18)<<XY(7,25)<<XY(8,26)<<XY(9,15)<<XY(10,12)<<XY(11,7)<<XY(12,-6);
	scatter4.AddSeries(s2,"2006",true,LtRed);
	
	scatter4.Graduation_FormatX(Scatter::MON);
	WString sl="Temperature [";
	sl.Cat(176);
	sl.Cat("C]");
	scatter4.SetLabelY(sl);
	scatter4.SetMarkStyle(1,Scatter::RECTANGLE);
	scatter4.SetMarkWidth(1,24);
}


class TestScatter2 : public WithTestScatter2Layout<TopWindow> {
	
	Tab1 tab1;
	Tab2 tab2;
	Tab3 tab3;
	Tab4 tab4;
		
	typedef TestScatter2 CLASSNAME;
	
public:
	
	TestScatter2();
	void Preview();
	void SavePNG();
	void SaveJPG();
	void SaveEMF();

};

#endif

