#ifndef _Archive_config_h_
#define _Archive_config_h_

#if __GNUC__

	#define GCC_VERSION (__GNUC__ * 10000 \
		               + __GNUC_MINOR__ * 100 \
		               + __GNUC_PATCHLEVEL__)	

	#define COMPILER_GCC 1
	
	#if defined(__WIN32) || defined(_WIN32) || defined(WIN32)
		#define COMPILER_MINGW 1
		#define PLATFORM_WIN32 1
		#undef  WINVER
		#undef  _WIN32_WINNT
		#define _WIN32_WINNT 0x0501
	#endif

	#if __unix || __unix__ || __APPLE__
		#define PLATFORM_POSIX 1
		
		#if __linux
			#define PLATFORM_LINUX 1
			#if __ANDROID__
				#define PLATFORM_ANDROID 1
			#endif
		// zvzv add
		// __linux is undef on APPLE MACOSX, MACOSX has BSD stuff
		#elif __APPLE__
			// zvzv note
			// s/b MACOSX
			#define PLATFORM_OSX11 1
			#define PLATFORM_BSD 1
		#else
			// zvzv mod
			// was: #if __FreeBSD__ || __OpenBSD__ || __NetBSD__ || __APPLE__
			#if __FreeBSD__ || __OpenBSD__ || __NetBSD__ || __DragonFly__
				#define PLATFORM_BSD 1
				#if __FreeBSD__
					#define PLATFORM_FREEBSD 1
				#endif
				#if __OpenBSD__
					#define PLATFORM_OPENBSD 1
				#endif
				#if __NetBSD__
					#define PLATFORM_NETBSD 1
				#endif
				#if __DragonFly__
					#define PLATFORM_DRAGONFLY 1
				#endif
			#elif __sun
				#define PLATFORM_SOLARIS 1
			#else
				#error Unknown OS
			#endif
		#endif
	#endif
	
	#if  __x86_64
		#define CPU_LE 1
		#define CPU_LITTLE_ENDIAN 1
		#define CPU_UNALIGNED 1
		#define CPU_X86 1
		#define CPU_64 1
		#define CPU_AMD64 1
		#define CPU_SSE2 1
		#define CPU_IA64 1
	#elif __i386 || __i386__ || i386
		#define CPU_LE 1
		#define CPU_LITTLE_ENDIAN 1
		#define CPU_UNALIGNED 1
		#define CPU_X86 1
		#define CPU_32 1
		#define CPU_IA32 1
		#define CPU_SSE2 1
	#elif __sparc  // ToDo!
		#define CPU_32 1
		#define CPU_SPARC 1
		#define CPU_BE 1
		#define CPU_BIG_ENDIAN 1
		#define CPU_ALIGNED 1
	#elif __aarch64__
		#define CPU_64 1
		#define CPU_ARM 1
		#define CPU_LE 1
		#define CPU_LITTLE_ENDIAN 1
		#define CPU_UNALIGNED 1
	#elif __arm__
		#define CPU_32 1
		#define CPU_ARM 1
		#ifdef __ARM_BIG_ENDIAN
			#define CPU_BE 1
			#define CPU_BIG_ENDIAN 1
		#else
			#define CPU_LE 1
			#define CPU_LITTLE_ENDIAN 1
		#endif
		#ifdef __ARM_FEATURE_UNALIGNED
			#define CPU_UNALIGNED 1
		#else
			#define CPU_ALIGNED 1
		#endif
	#elif __bfin
		#define CPU_32 1
		#define CPU_BLACKFIN
		#define CPU_LE 1
		#define CPU_LITTLE_ENDIAN 1
		#define CPU_ALIGNED 1
		#define _HAVE_NO_STDWSTRING 1
		//BF toolchain has no support for __thread (TLS), so U++ Heap not possible
		#define flagUSEMALLOC
	#else
		#error Unknown CPU architecture
	#endif
#endif

#ifdef _MSC_VER
	#define COMPILER_MSC 1
	#pragma warning(disable: 4786)
	#define _CRT_SECURE_NO_DEPRECATE 1 // we really need strcpy etc. to work with MSC 8.0
	
	#define PLATFORM_WIN32 1

	#define CPU_LE 1
	#define CPU_LITTLE_ENDIAN 1
	#define CPU_UNALIGNED 1
	#define CPU_X86 1

	#ifdef _WIN64
		#define PLATFORM_WIN64 1
		#define CPU_64 1
		#define CPU_AMD64 1
		#define CPU_SSE2 1
		#define CPU_IA64 1
	#else
		#define CPU_32 1
		#define CPU_IA32 1
		#define CPU_SSE2 1
	#endif			
#endif

#ifdef  flagCLR
#define flagUSEMALLOC
#endif

#if defined(PLATFORM_WIN32)

	#define HAVE_INTTYPES_H			1
	#define HAVE_STDINT_H			1
//	#define HAVE_UNISTD_H			1
	#define HAVE_SYS_TYPES_H		1
	#define HAVE_STDLIB_H			1
	#define HAVE_STDIO_H			1
	#define HAVE_SYS_TIME_H			1
	#define HAVE_SYS_STAT_H			1
	#define HAVE_ERRNO_H			1
	#define HAVE_LIMITS_H			1
	#define HAVE_STRING_H			1
	#define HAVE_WCHAR_H			1
	#define HAVE_WINCRYPT_H			1

	#define HAVE__GET_TIMEZONE		1

	#define HAVE__FSEEKI64			1

	#define HAVE_DECL_SIZE_MAX		1
	#define HAVE_DECL_UINT32_MAX	1
	#define HAVE_DECL_INT32_MAX		1
	#define HAVE_DECL_INT32_MIN		1
	#define HAVE_DECL_UINT64_MAX	1
	#define HAVE_DECL_INT64_MAX		1
	#define HAVE_DECL_INT64_MIN		1
	#define HAVE_DECL_UINTMAX_MAX	1
	#define HAVE_DECL_INTMAX_MAX	1
	#define HAVE_DECL_INTMAX_MIN	1

	#define HAVE_WCSCPY				1
	#define HAVE_WCSLEN				1

	#define HAVE_ZLIB_H				1
	#define HAVE_BZLIB_H			1

	#include <BaseTsd.h>
	typedef SSIZE_T ssize_t;

//	#include <sys/stat.h>
	#include <stdint.h>
	
	typedef int pid_t;
	typedef int gid_t;
	typedef unsigned short mode_t;
	typedef int uid_t;
	typedef int id_t;
	
	#define LIBARCHIVE_STATIC

#elif defined(PLATFORM_POSIX)

	#define HAVE_INTTYPES_H			1
	#define HAVE_STDINT_H			1
	#define HAVE_ERRNO_H			1

	#define HAVE_DECL_SIZE_MAX		1
	#define HAVE_DECL_SSIZE_MAX		1
	#define HAVE_DECL_UINT32_MAX	1
	#define HAVE_DECL_INT32_MAX		1
	#define HAVE_DECL_INT32_MIN		1
	#define HAVE_DECL_UINT64_MAX	1
	#define HAVE_DECL_INT64_MAX		1
	#define HAVE_DECL_INT64_MIN		1
	#define HAVE_DECL_UINTMAX_MAX	1
	#define HAVE_DECL_INTMAX_MAX	1
	#define HAVE_DECL_INTMAX_MIN	1
	#define HAVE_FCHDIR				1
	#define HAVE_GRP_H				1
	#define HAVE_GETPWNAM_R			1
	#define HAVE_LSTAT				1
	#define HAVE_PWD_H				1
	#define HAVE_SYS_UTSNAME_H		1
	#define HAVE_DIRENT_H			1
	#define HAVE_STRING_H			1
	#define HAVE_WCHAR_H			1
	#define HAVE_STDLIB_H			1
	#define HAVE_STDIO_H			1
	#define HAVE_FCNTL				1
	#define HAVE_FCNTL_H			1
	#define HAVE_WCSCPY				1
	#define HAVE_WCSLEN				1
	#define HAVE_UNISTD_H			1
	#define HAVE_LIMITS_H			1
	#define HAVE_SYS_TYPES_H		1
	
	#define HAVE_PIPE				1
	#define HAVE_FORK				1
	#define HAVE_VFORK				1
	#define HAVE_POSIX_SPAWNP		1
	#define HAVE_SPAWN_H			1
	
	#define HAVE_ZLIB_H				1
	#define HAVE_BZLIB_H			1
	
	#define HAVE_UTIMENSAT			1
	#define HAVE_FUTIMENS			1
	#define HAVE_FCHDIR				1
	#define HAVE_LINK				1
	#define HAVE_SYMLINK			1
	#define HAVE_LSTAT				1


#else

	#error "Unsupported platform"

#endif

#endif
