#include "JobQueue.h"

NAMESPACE_UPP;

void JobQueue::Pick(JobQueue&& jq)
{
	queue      = pick(jq.queue); 
	halted     = jq.halted; 
	start_time = jq.start_time; 
	timeout    = jq.timeout; 
	error_code = jq.error_code;
	error_desc = pick(jq.error_desc);          
}

bool JobQueue::Halt(const char* reason, int code)
{
	halted     = true; 
	error_desc = reason;  
	error_code = code; 
	return false; 
}

bool JobQueue::Do()
{
	while(!start_time) {
		start_time = msecs();
		error_code = 0;
		error_desc.Clear(); 
	}
	
	if(!queue.IsEmpty()) {
		if(IsTimeout()) 
			Halt(t_("Operation timed out."));
		else
		if(!GetJob()() && !halted) 
			NextJob();
		if(halted) 
			queue.Clear();
		else
			WhenDo();
	}
	if(queue.IsEmpty() && start_time != 0)
		start_time = 0;	
 	return InProgress(); 
}
END_UPP_NAMESPACE;
