#include <Core/Core.h>
#include <JobQueue/JobQueue.h>

using namespace Upp;

class ClientSockets : public JobQueue {
	TcpSocket	socket;
	IpAddrInfo	addrinfo;
	String 		packet;
	int 		packet_length;
	int			id;
	String		result;
	
	bool		CheckErrors()	{ return socket.IsError() ? Halt(Format("Client %d failed. %s", id, socket.GetErrorDesc())) : true; }

public:
	TcpSocket&	GetSocket()		{ return socket; }
	String		GetResult()		{ return Format("Client %d received timestamp: %s", id, packet); }
	void		StartRequest(int client_id, const String& request);
	
	ClientSockets() {};
};

void ClientSockets::StartRequest(int client_id, const String& request)
{
	// Init()
	AddJob() << [&, client_id] {
		id = client_id;
		packet.Clear();
		packet_length = 0;
		socket.Timeout(0);
		addrinfo.Start("127.0.0.1", 3214);
		return false;
	};
	// DNS
	AddJob() << [&] {
		if(addrinfo.InProgress())
			return true;
		return addrinfo.GetResult() == NULL ? Halt("Couldn't resolve hostname.") : false;
	};
	// Connect()
	AddJob() << [&] {
		if(!socket.Connect(addrinfo))
			return CheckErrors();
		addrinfo.Clear();
		return false;
	};
	// Put()
	AddJob() << [&, request] {
		int l = 0;
		while((l = socket.Put(request, request.GetLength() - packet_length)) > 0)
			packet_length += l;
		return packet_length != request.GetLength() ? CheckErrors() : false;
	};
	// Get()
	AddJob() << [&] {
		int c = -1;
		while((c = socket.Get()) != -1) 
			packet.Cat(c);
		return !packet.EndsWith("\n") ? CheckErrors() : false;
	};
}

CONSOLE_APP_MAIN
{
	Array<ClientSockets> clients;
	for(int i = 0; i < 5; i++) {
		ClientSockets& cs = clients.Add();
		cs.StartRequest(i + 1, "time\n");
		cs.Timeout(10000);
	}
			
	while(!clients.IsEmpty()) {
		int i = 0;
		SocketWaitEvent we;
		we.Add(clients[i].GetSocket());
		we.Wait(10);
		while(i < clients.GetCount()) {
			ClientSockets& client = clients[i];
			if(!client.Do()) {
				if(client.IsFailure())
					Cout() << client.GetErrorDesc() << "\n";
				else
//				if(client.IsSuccess())
					Cout() << client.GetResult() << "\n";
				clients.Remove(i);
				break;
			}
			i++;
		}
	}
}
