#include "MDNSTest.h"

MDNSTest::MDNSTest()
{
	CtrlLayout(*this, "MDNS Test");
	listenBtn <<= THISBACK(listenCb);
	stopBtn <<= THISBACK(stopCb);
	clearBtn <<= THISBACK(clearCb);
	
	MDNS.WhenService = THISBACK(serviceCb);
	
	// listen for 'arduino:tcp' services
	MDNS.ListenFor("arduino", "tcp");
}

void MDNSTest::Dump(String const &s)
{
	String msg = dumpBox.Get();
	msg << s;
	dumpBox.Set(msg);
	dumpBox.SetCursor(INT_MAX);
}

void MDNSTest::serviceCb(void)
{
	Array<MDNSService> services = MDNS.GetDiscoveredServices("arduino", "tcp");
	Dump(Format("Services changed - count is %d:\n", services.GetCount()));
	
	for(int i = 0; i < services.GetCount(); i++)
	{
		Dump(Format("Host : %s\n", services[i].GetHostName()));
		Dump(Format("Ip   : %s\n", services[i].GetIP().ToString()));
		Dump("\n");
	}
	Dump("---------------------------------------------\n");
}

void MDNSTest::listenCb(void)
{
	Dump("START LISTENING FOR MDNS PACKETS\n");
	MDNS.Listen();
	PostCallback(THISBACK(loopCb));
}

void MDNSTest::stopCb(void)
{
	MDNS.NoListen();
	Dump("\nSTOPPED\n");
}

void MDNSTest::clearCb(void)
{
	dumpBox.Clear();
}

void MDNSTest::loopCb(void)
{
	if(!MDNS.IsListening())
		return;
	MDNS.Loop();
	PostCallback(THISBACK(loopCb));
}

GUI_APP_MAIN
{
	MDNSTest().Run();
}
