#include "MTtest.h"

MTT::MTT()
{
	CtrlLayout(*this, "Threading test");
	grid.Ready(false);
	grid.AddColumn("SKU").Width(75);
	grid.AddColumn("DESCR").Width(500);
	grid.AddColumn("QTY");
	load.WhenPush = [&]
	{
		FileSelector fs;
		fs.Type("csv files", "*.csv");
		if(fs.ExecuteOpen(t_("Select File")))
		{
			loadFile(~fs);
		}
	};
	run <<= THISBACK(processFile);
	progin.Set(0,100);
	
}

//void MTT::RemoveItem(int i, int j)
//{
//	PostCallback([=] { 
//			grid.Remove(i);
//			// bla bla...
//	});
//}

void MTT::processFile()
{
	int rowc = grid.GetRowCount();
	progin.Percent();

	Thread().Run([=] {
		for(auto i = rowc - 1, j = 0; i >= 0; i--, j++) {
			if(IsShutdownThreads())
				break;
//			int q = grid(i, 2); 
//			if(q <= 0)
//				this->RemoveItem(i, j);  // You can also use a dedicated method.
				PostCallback([=] { 
					grid.Remove(i); 
					progin.Set(j, rowc - 1); 
				});

			Sleep(10);
		}
	});
}

void MTT::loadFile(String fp)
{
	FileIn in(fp);

	grid.Clear();
	
	while(!in.IsEof())
	{
		String line = in.GetLine();
		Vector<String> fields = Split(line, ",");
		grid.Add(fields[0],fields[1],ScanInt(fields[2]));
	}
	grid.Ready(true);
	in.Close();
}

GUI_APP_MAIN
{
	MTT().Run();
}
