#ifndef _Inventory_Inventory_h
#define _Inventory_Inventory_h

#include <CtrlLib/CtrlLib.h>
#include <GridCtrl/GridCtrl.h>
#include <SqlCtrl/SqlCtrl.h>
#include <plugin/sqlite3/Sqlite3.h>

#define ME_SINGLE
// ME_NONE, ME_SINGLE, ME_MULTI

// NONE: Purely linear processing
// SINGLE: single Thread() worker
// MULTI: multiple CoWork() workers

using namespace Upp;

#define LAYOUTFILE <MTSQLTest/Inventory.lay>
#include <CtrlCore/lay.h>

#define SCHEMADIALECT <plugin/sqlite3/Sqlite3Schema.h>
#define MODEL <MTSQLTest\sqlite.sch>
#include "Sql/sch_header.h"

class MTT : public WithStockLayout<TopWindow> {
	WithOUTBOUND<ParentCtrl> outab;
	StatusBar statbar;
	
	#ifdef ME_SINGLE
	Thread wrk;
	#endif
	
	#ifdef ME_MULTI
	CoWork wrks;
	void precheckSlave(int i, bool* k);
	void processSlave(int i, bool* k);
	#endif
	
	void MainMenu(Bar& bar);
	void readOutbound();
	void precheckOutbound();
	void processOutbound();
	void Exit();
public:
	typedef MTT CLASSNAME;
	MTT();
};

#endif
