#include "Inventory.h"

#define SCHEMADIALECT <plugin/sqlite3/Sqlite3Schema.h>
#include "Sql/sch_source.h"
#include "Sql/sch_schema.h"

MTT::MTT()
{
	CtrlLayout(*this, "Multithreading Test2");
	CtrlLayout(outab);
	Zoomable().Sizeable();
	AddFrame(statbar);
	
	menu.Set(THISBACK(MainMenu));
	outab.ofs.WhenPush = [&]
	{
		FileSelector fs;
		fs.Type("csv files", "*.csv");
		if(fs.ExecuteOpen(t_("Select File")))
		{
			outab.csv_filepath = ~fs;
			readOutbound();
		}
	};
	outab.processdb <<= THISBACK(processOutbound);
	outab.processdb.Disable();
	
	tab.Add(outab.SizePos(),t_("Outbound"));
}

void MTT::MainMenu(Bar& bar)
{
	bar.Add("SQL console", callback(SQLCommander));
}

void MTT::readOutbound()
{
	FileIn in(String(~outab.csv_filepath));

	outab.cont.Ready(false);
	outab.cont.Reset();
	outab.cont.EvenColor();
	outab.cont.ColoringMode(2);
	
	outab.cont.AddColumn("Type",100);
	outab.cont.AddColumn("Date",100);
	outab.cont.AddColumn("Number",100);
	outab.cont.AddColumn("Item",500);
	outab.cont.AddColumn("Quantity",60);
	
	while(!in.IsEof())
	{
		String line = in.GetLine();
		Vector<String> row = Split(line, ",");
		for(int i = 0; i<4; i++)
		{
			row[i].TrimStart("\"");
			row[i].TrimEnd("\"");
		}
		outab.cont.Add(row[0], row[1], row[2], row[3], StrDbl(row[5]));
	}
	in.Close();
	outab.cont.Ready(true);
	outab.processdb.Enable();
}

void MTT::Exit()
{
	if(PromptOKCancel(t_("Close Inventory System?")))
	{
		Break();
	}
}
GUI_APP_MAIN
{
	SQL;
	Sqlite3Session sqlite3;
	String dbfile = ConfigFile("stock.db3");
	if (!FileExists(dbfile))
	{
		if(!sqlite3.Open( dbfile )) {
			Exclamation(t_("Can't create or open database file"));
			return;
		}
		SQL = sqlite3;
		SqlSchema sch(SQLITE3);
		sqlite3.SetTrace();
		All_Tables(sch);
		if(sch.ScriptChanged(SqlSchema::UPGRADE))
			Sqlite3PerformScript(sch.Upgrade());
		if(sch.ScriptChanged(SqlSchema::ATTRIBUTES))
			Sqlite3PerformScript(sch.Attributes());
		if(sch.ScriptChanged(SqlSchema::CONFIG))
		{
			Sqlite3PerformScript(sch.ConfigDrop());
			Sqlite3PerformScript(sch.Config());
		}
		sch.SaveNormal();
		sqlite3.SetTrace();
	}
	else
	{
		if(!sqlite3.Open( dbfile )) {
			Exclamation(t_("Can't create or open database file"));
			return;
		}
		SQL = sqlite3;
		sqlite3.SetTrace();
	}
	
	MTT().Run();
}
