#include "Inventory.h"
#ifdef ME_NONE
void MTT::precheckOutbound()
{
	int numr = outab.cont.GetCount();
	PromptOK(Format("There are %d rows to precheck", numr));
	int64 now = GetUTCSeconds(Time());
	ProgressInfo f(statbar);
	f.Text("Prechecking File:");
	int p=0;
	f.Set(p,numr);
	
	for (int i = 0; i < outab.cont.GetCount(); i++)
	{
		p++;
		f.Set(p,numr);
		ProcessEvents();
		outab.cont.GetRow(i).Bg(LtGray());
		// fetch data from grid
		String typ  = outab.cont(i,0);
		String date = outab.cont(i,1);
		String ordr = outab.cont(i,2);
		String item = outab.cont(i,3);
		double qtty = double(outab.cont(i,4));
		
		int splitpos = item.Find(":");
		if(splitpos > 0 && splitpos < 10)
			item = item.Mid(++splitpos);
	
		Vector<String> mdy = Split(3,date,"/");
		int64 otis = GetUTCSeconds(Time(StrInt(mdy[2]), StrInt(mdy[0]), StrInt(mdy[1])));
		
		if (ToUpper(TrimBoth(item)).StartsWith("SHIPPING"))
		{
			outab.cont.Remove(i);
			i--;
			continue;
		}
		// Sleep to reflect the increased time it takes to do that with a remote MySQL instead
		// of the local sqlite db
		Sleep(50);
		//
		SQL * Select(SqlAll()).From(OUTB).Where(ORDERID == ordr && ITEM == item && DATUM == otis && TYP == typ);
		if(SQL.Fetch())
		{
			if(SQL[QTY] == qtty)
			{
				outab.cont.Remove(i);
				i--;
			}
			else
			{
				//Possible change of quantity
				if(PromptYesNo(Format("Already processed %d of %s, new quantity %d & Do you want to update the Quantity?", SQL[QTY], SQL[ITEM], qtty)))
				{
					int pid = SQL[ID];
					int cqty = SQL[QTY];
					int stockid = SQL[STOCKID];
					int diff = cqty - qtty;
					Sleep(50);
					SQL * SqlUpdate(OUTB)(QTY, qtty).Where(ID == pid);
					
					PromptOK(Format("Stock ( %d ) and outbound ( %d ) table updated!", diff, qtty));
					outab.cont.Remove(i);
					i--;
				}
				else
				{
					PromptOK("entry removed");
					outab.cont.Remove(i);
					i--;
				}
			}
		}
	}
}

void MTT::processOutbound()
{
	outab.processdb.Disable();
	
	if(~outab.precheck)
		precheckOutbound();
	
	int numr = outab.cont.GetCount();
	PromptOK(Format("There are %d rows to process", numr));
	ProgressInfo f(statbar);
	f.Text("Processing File:");
	int p=0;
	f.Set(p,numr);
	
	int64 now = GetUTCSeconds(Time());

	for (int i = 0; i < numr; i++)
	{
		p++;
		f.Set(p,numr);
		ProcessEvents();
		outab.cont.GetRow(i).Bg(Yellow());
		// fetch data from grid
		String typ  = outab.cont(i,0);
		String date = outab.cont(i,1);
		String ordr = outab.cont(i,2);
		String item = outab.cont(i,3);
		double qtty = double(outab.cont(i,4));
		
		int splitpos = item.Find(":");
		if(splitpos > 0 && splitpos < 10)
			item = item.Mid(++splitpos);
	
		Vector<String> mdy = Split(3,date,"/");
		int64 otis = GetUTCSeconds(Time(StrInt(mdy[2]), StrInt(mdy[0]), StrInt(mdy[1])));
				
		splitpos = item.Find("(");
		if(splitpos > 0)
		{
			String sku = TrimBoth(item.Left(splitpos));
			String desc = TrimBoth(item.Mid(splitpos));
		
			desc.TrimStart("(");
			desc.TrimEnd(")");
			
			if(Random()%200 < 100)
			{
				Sleep(50);
				SQL * Insert(OUTB)
					(ORDERID, ordr)
					(STOCKID, 1)
					(SKU, sku)
					(ITEM, item)
					(QTY, qtty)
					(DATUM, otis)
					(TYP, typ);
				
				if(SQL.WasError())
				{
					LOG(Format("############  ERROR\n %s\n for query:\n %s\n\n",SQL.GetLastError(),SQL.GetErrorStatement()));
					SQL.ClearError();
					outab.cont.GetRow(i).Bg(LtRed());
					continue;
				}
				outab.cont.GetRow(i).Bg(LtGreen());
			}
			else
			{
				outab.cont.GetRow(i).Bg(LtRed());
			}
		}
		else
		{
			outab.cont.GetRow(i).Bg(LtRed());
		}
	}
}
#endif